/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial.neighborhood.weighted;

import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDPair;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.relation.Relation;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.outlier.spatial.neighborhood.weighted.WeightedNeighborSetPredicate;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

public class LinearWeightedExtendedNeighborhood
implements WeightedNeighborSetPredicate {
    private NeighborSetPredicate inner;
    private int steps;

    public LinearWeightedExtendedNeighborhood(NeighborSetPredicate inner, int steps) {
        this.inner = inner;
        this.steps = steps;
    }

    private double computeWeight(int tsteps) {
        return 1.0 - (double)((float)tsteps / (float)(this.steps + 1));
    }

    @Override
    public Collection<DoubleDBIDPair> getWeightedNeighbors(DBIDRef reference) {
        HashSetModifiableDBIDs seen = DBIDUtil.newHashSet();
        ArrayList<DoubleDBIDPair> result = new ArrayList<DoubleDBIDPair>();
        result.add(DBIDUtil.newPair((double)this.computeWeight(0), (DBIDRef)reference));
        seen.add(reference);
        DBID cur = DBIDUtil.deref((DBIDRef)reference);
        for (int i = 1; i <= this.steps; ++i) {
            double weight = this.computeWeight(i);
            HashSetModifiableDBIDs add = DBIDUtil.newHashSet();
            DBIDIter iter = cur.iter();
            while (iter.valid()) {
                DBIDIter iter2 = this.inner.getNeighborDBIDs((DBIDRef)iter).iter();
                while (iter2.valid()) {
                    if (!seen.contains((DBIDRef)iter2)) {
                        add.add((DBIDRef)iter2);
                        result.add(DBIDUtil.newPair((double)weight, (DBIDRef)iter2));
                    }
                    iter2.advance();
                }
                iter.advance();
            }
            if (add.size() == 0) break;
            cur = add;
        }
        return result;
    }

    public static class Factory<O>
    implements WeightedNeighborSetPredicate.Factory<O> {
        private NeighborSetPredicate.Factory<O> inner;
        private int steps;

        public Factory(NeighborSetPredicate.Factory<O> inner, int steps) {
            this.inner = inner;
            this.steps = steps;
        }

        @Override
        public LinearWeightedExtendedNeighborhood instantiate(Database database, Relation<? extends O> relation) {
            return new LinearWeightedExtendedNeighborhood(this.inner.instantiate(database, relation), this.steps);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        public static class Par<O>
        implements Parameterizer {
            public static final OptionID NEIGHBORHOOD_ID = new OptionID("extendedneighbors.neighborhood", "The inner neighborhood predicate to use.");
            public static final OptionID STEPS_ID = new OptionID("extendedneighbors.steps", "The number of steps allowed in the neighborhood graph.");
            private int steps;
            private NeighborSetPredicate.Factory<O> inner;

            public void configure(Parameterization config) {
                new ObjectParameter(NEIGHBORHOOD_ID, NeighborSetPredicate.Factory.class).grab(config, x -> {
                    this.inner = x;
                });
                ((IntParameter)new IntParameter(STEPS_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.steps = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.inner, this.steps);
            }
        }
    }
}

