/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial.neighborhood;

import elki.data.ExternalID;
import elki.data.LabelList;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.outlier.spatial.neighborhood.AbstractPrecomputedNeighborhood;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.HashMap;

public class ExternalNeighborhood
extends AbstractPrecomputedNeighborhood {
    private static final Logging LOG = Logging.getLogger(ExternalNeighborhood.class);

    public ExternalNeighborhood(DataStore<DBIDs> store) {
        super(store);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory
    extends AbstractPrecomputedNeighborhood.Factory<Object> {
        private URI file;

        public Factory(URI file) {
            this.file = file;
        }

        @Override
        public NeighborSetPredicate instantiate(Database database, Relation<?> relation) {
            return new ExternalNeighborhood(this.loadNeighbors(database, relation));
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.ANY;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private DataStore<DBIDs> loadNeighbors(Database database, Relation<?> relation) {
            WritableDataStore store = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)7, DBIDs.class);
            if (LOG.isVerbose()) {
                LOG.verbose((CharSequence)"Loading external neighborhoods.");
            }
            if (LOG.isDebugging()) {
                LOG.verbose((CharSequence)"Building reverse label index...");
            }
            HashMap<String, DBID> lblmap = new HashMap<String, DBID>(relation.size() << 1);
            Relation olq = database.getRelation((TypeInformation)TypeUtil.LABELLIST, new Object[0]);
            Relation eidq = database.getRelation((TypeInformation)TypeUtil.EXTERNALID, new Object[0]);
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                LabelList label;
                ExternalID eid;
                if (eidq != null && (eid = (ExternalID)eidq.get((DBIDRef)iditer)) != null) {
                    lblmap.put(eid.toString(), DBIDUtil.deref((DBIDRef)iditer));
                }
                if (olq != null && (label = (LabelList)olq.get((DBIDRef)iditer)) != null) {
                    for (int i = 0; i < label.size(); ++i) {
                        lblmap.put(label.get(i), DBIDUtil.deref((DBIDRef)iditer));
                    }
                }
                iditer.advance();
            }
            if (LOG.isDebugging()) {
                LOG.verbose((CharSequence)"Loading neighborhood file.");
            }
            try (InputStream in = FileUtil.open((URI)this.file, (OpenOption[])new OpenOption[0]);){
                WritableDataStore writableDataStore;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        ArrayModifiableDBIDs neighbours = DBIDUtil.newArray();
                        String[] entries = line.split(" ");
                        DBID id = (DBID)lblmap.get(entries[0]);
                        if (id != null) {
                            for (int i = 0; i < entries.length; ++i) {
                                DBID neigh = (DBID)lblmap.get(entries[i]);
                                if (neigh != null) {
                                    neighbours.add((DBIDRef)neigh);
                                    continue;
                                }
                                if (!LOG.isDebugging()) continue;
                                LOG.debug((CharSequence)("No object found for label " + entries[i]));
                            }
                            store.put((DBIDRef)id, (Object)neighbours);
                            continue;
                        }
                        if (!LOG.isDebugging()) continue;
                        LOG.warning((CharSequence)("No object found for label " + entries[0]));
                    }
                    writableDataStore = store;
                }
                return writableDataStore;
            }
            catch (IOException e) {
                throw new AbortException("Loading of external neighborhood failed.", (Throwable)e);
            }
        }

        public static class Par
        implements Parameterizer {
            public static final OptionID NEIGHBORHOOD_FILE_ID = new OptionID("externalneighbors.file", "The file listing the neighbors.");
            URI file;

            public void configure(Parameterization config) {
                new FileParameter(NEIGHBORHOOD_FILE_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                    this.file = x;
                });
            }

            public Factory make() {
                return new Factory(this.file);
            }
        }
    }
}

