/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial.neighborhood;

import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.outlier.spatial.neighborhood.AbstractPrecomputedNeighborhood;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class ExtendedNeighborhood
extends AbstractPrecomputedNeighborhood {
    private static final Logging LOG = Logging.getLogger(ExtendedNeighborhood.class);

    public ExtendedNeighborhood(DataStore<DBIDs> store) {
        super(store);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractPrecomputedNeighborhood.Factory<O> {
        private NeighborSetPredicate.Factory<O> inner;
        private int steps;

        public Factory(NeighborSetPredicate.Factory<O> inner, int steps) {
            this.inner = inner;
            this.steps = steps;
        }

        @Override
        public NeighborSetPredicate instantiate(Database database, Relation<? extends O> relation) {
            DataStore<DBIDs> store = this.extendNeighborhood(database, relation);
            ExtendedNeighborhood neighborhood = new ExtendedNeighborhood(store);
            return neighborhood;
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        private DataStore<DBIDs> extendNeighborhood(Database database, Relation<? extends O> relation) {
            NeighborSetPredicate innerinst = this.inner.instantiate(database, relation);
            WritableDataStore store = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)7, DBIDs.class);
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Expanding neighborhoods", relation.size(), LOG) : null;
            DBIDIter iter = relation.iterDBIDs();
            while (iter.valid()) {
                HashSetModifiableDBIDs res = DBIDUtil.newHashSet();
                res.add((DBIDRef)iter);
                DBID todo = DBIDUtil.deref((DBIDRef)iter);
                for (int i = 0; i < this.steps; ++i) {
                    HashSetModifiableDBIDs ntodo = DBIDUtil.newHashSet();
                    DBIDIter iter2 = todo.iter();
                    while (iter2.valid()) {
                        DBIDs add = innerinst.getNeighborDBIDs((DBIDRef)iter2);
                        if (add != null) {
                            DBIDIter iter3 = add.iter();
                            while (iter3.valid()) {
                                if (!res.contains((DBIDRef)iter3)) {
                                    ntodo.add((DBIDRef)iter3);
                                    res.add((DBIDRef)iter3);
                                }
                                iter3.advance();
                            }
                        }
                        iter2.advance();
                    }
                    if (ntodo.size() == 0) continue;
                    todo = ntodo;
                }
                store.put((DBIDRef)iter, (Object)res);
                LOG.incrementProcessed((AbstractProgress)progress);
                iter.advance();
            }
            LOG.ensureCompleted(progress);
            return store;
        }

        public static class Par<O>
        implements Parameterizer {
            public static final OptionID NEIGHBORHOOD_ID = new OptionID("extendedneighbors.neighborhood", "The inner neighborhood predicate to use.");
            public static final OptionID STEPS_ID = new OptionID("extendedneighbors.steps", "The number of steps allowed in the neighborhood graph.");
            private int steps;
            private NeighborSetPredicate.Factory<O> inner;

            public void configure(Parameterization config) {
                new ObjectParameter(NEIGHBORHOOD_ID, NeighborSetPredicate.Factory.class).grab(config, x -> {
                    this.inner = x;
                });
                ((IntParameter)new IntParameter(STEPS_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.steps = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.inner, this.steps);
            }
        }
    }
}

