/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.math.DoubleMinMax;
import elki.outlier.spatial.AbstractDistanceBasedSpatialOutlier;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.result.Metadata;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="Spatial Outlier Factor")
@Reference(authors="T. Huang, X. Qin", title="Detecting outliers in spatial database", booktitle="Proc. 3rd International Conference on Image and Graphics", url="https://doi.org/10.1109/ICIG.2004.53", bibkey="DBLP:conf/icig/HuangQ04")
public class SOF<N, O>
extends AbstractDistanceBasedSpatialOutlier<N, O> {
    public SOF(NeighborSetPredicate.Factory<N> npred, PrimitiveDistance<O> nonSpatialDistance) {
        super(npred, nonSpatialDistance);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Database database, Relation<N> spatial, Relation<O> relation) {
        double lrd;
        double avg;
        DBIDs neighbors;
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, spatial);
        DistanceQuery distFunc = this.getNonSpatialDistance().instantiate(relation);
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3);
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            neighbors = npred.getNeighborDBIDs((DBIDRef)iditer);
            avg = 0.0;
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                avg += distFunc.distance((DBIDRef)iditer, (DBIDRef)iter);
                iter.advance();
            }
            lrd = 1.0 / (avg / (double)neighbors.size());
            if (Double.isNaN(lrd)) {
                lrd = 0.0;
            }
            lrds.putDouble((DBIDRef)iditer, lrd);
            iditer.advance();
        }
        iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            neighbors = npred.getNeighborDBIDs((DBIDRef)iditer);
            avg = 0.0;
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                avg += lrds.doubleValue((DBIDRef)iter);
                iter.advance();
            }
            lrd = avg / (double)neighbors.size() / lrds.doubleValue((DBIDRef)iditer);
            if (!Double.isNaN(lrd)) {
                lofs.putDouble((DBIDRef)iditer, lrd);
                lofminmax.put(lrd);
            } else {
                lofs.putDouble((DBIDRef)iditer, 0.0);
            }
            iditer.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Spatial Outlier Factor", relation.getDBIDs(), (DoubleDataStore)lofs);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult or = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)or).addChild((Object)npred);
        return or;
    }

    public static class Par<N, O>
    extends AbstractDistanceBasedSpatialOutlier.Par<N, O> {
        public SOF<N, O> make() {
            return new SOF(this.npredf, this.distance);
        }
    }
}

