/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.math.DoubleMinMax;
import elki.math.MeanVariance;
import elki.outlier.spatial.AbstractNeighborhoodOutlier;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="Median Algorithm for Spatial Outlier Detection")
@Reference(authors="C.-T. Lu, D. Chen, Y. Kou", title="Algorithms for Spatial Outlier Detection", booktitle="Proc. 3rd IEEE International Conference on Data Mining", url="https://doi.org/10.1109/ICDM.2003.1250986", bibkey="DBLP:conf/icdm/LuCK03")
public class CTLuMedianAlgorithm<N>
extends AbstractNeighborhoodOutlier<N> {
    public CTLuMedianAlgorithm(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D});
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        MeanVariance mv = new MeanVariance();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            DBIDs neighbors = npred.getNeighborDBIDs((DBIDRef)iditer);
            double[] fi = new double[neighbors.size()];
            int c = 0;
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iditer, (DBIDRef)iter)) {
                    fi[c] = ((NumberVector)relation.get((DBIDRef)iter)).doubleValue(0);
                    ++c;
                }
                iter.advance();
            }
            double median = c > 0 ? QuickSelect.median((double[])fi, (int)0, (int)c) : ((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(0);
            double h = ((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(0) - median;
            scores.putDouble((DBIDRef)iditer, h);
            mv.put(h);
            iditer.advance();
        }
        double mean = mv.getMean();
        double stddev = mv.getPopulationStddev();
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double score = Math.abs((scores.doubleValue((DBIDRef)iditer2) - mean) / stddev);
            minmax.put(score);
            scores.putDouble((DBIDRef)iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("MO", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)or).addChild((Object)npred);
        return or;
    }

    public static class Par<N>
    extends AbstractNeighborhoodOutlier.Par<N> {
        public CTLuMedianAlgorithm<N> make() {
            return new CTLuMedianAlgorithm(this.npredf);
        }
    }
}

