/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.Algorithm;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.ProxyView;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.math.DoubleMinMax;
import elki.math.linearalgebra.VMath;
import elki.math.statistics.distribution.NormalDistribution;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.pairs.Pair;

@Title(value="GLS-Backward Search")
@Reference(authors="F. Chen, C.-T. Lu, A. P. Boedihardjo", title="GLS-SOD: A Generalized Local Statistical Approach for Spatial Outlier Detection", booktitle="Proc. 16th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining", url="https://doi.org/10.1145/1835804.1835939", bibkey="DBLP:conf/kdd/ChenLB10")
public class CTLuGLSBackwardSearchAlgorithm<V extends NumberVector>
implements OutlierAlgorithm {
    protected Distance<? super V> distance;
    protected double alpha;
    protected int k;

    public CTLuGLSBackwardSearchAlgorithm(Distance<? super V> distance, int k, double alpha) {
        this.distance = distance;
        this.alpha = alpha;
        this.k = k;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Relation<V> relationx, Relation<? extends NumberVector> relationy) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relationx.getDBIDs(), (int)4);
        DoubleMinMax mm = new DoubleMinMax(0.0, 0.0);
        HashSetModifiableDBIDs idview = DBIDUtil.newHashSet((DBIDs)relationx.getDBIDs());
        ProxyView proxy = new ProxyView((DBIDs)idview, relationx);
        double phialpha = NormalDistribution.standardNormalQuantile((double)(1.0 - this.alpha * 0.5));
        while (true) {
            Pair<DBIDVar, Double> candidate = this.singleIteration((Relation<V>)proxy, relationy);
            if ((Double)candidate.second < phialpha) break;
            scores.putDouble((DBIDRef)candidate.first, ((Double)candidate.second).doubleValue());
            if (!Double.isNaN((Double)candidate.second)) {
                mm.put(((Double)candidate.second).doubleValue());
            }
            idview.remove((DBIDRef)candidate.first);
        }
        DBIDMIter iter = idview.iter();
        while (iter.valid()) {
            scores.putDouble((DBIDRef)iter, 0.0);
            iter.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("GLSSODBackward", relationx.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    private Pair<DBIDVar, Double> singleIteration(Relation<V> relationx, Relation<? extends NumberVector> relationy) {
        int dim = RelationUtil.dimensionality(relationx);
        int dimy = RelationUtil.dimensionality(relationy);
        assert (dim == 2);
        KNNSearcher knnQuery = new QueryBuilder(relationx, this.distance).kNNByDBID(this.k + 1);
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((DBIDs)relationx.getDBIDs());
        ids.sort();
        double[][] X = new double[ids.size()][6];
        double[][] F = new double[ids.size()][ids.size()];
        double[][] Y = new double[ids.size()][dimy];
        int i = 0;
        DBIDArrayMIter id = ids.iter();
        while (id.valid()) {
            NumberVector vec = (NumberVector)relationx.get((DBIDRef)id);
            double la = vec.doubleValue(0);
            double lo = vec.doubleValue(1);
            X[i][0] = 1.0;
            X[i][1] = la;
            X[i][2] = lo;
            X[i][3] = la * lo;
            X[i][4] = la * la;
            X[i][5] = lo * lo;
            NumberVector vecy = (NumberVector)relationy.get((DBIDRef)id);
            for (int d = 0; d < dimy; ++d) {
                double idy;
                Y[i][d] = idy = vecy.doubleValue(d);
            }
            KNNList neighbors = knnQuery.getKNN((Object)id, this.k + 1);
            ArrayModifiableDBIDs neighborhood = DBIDUtil.newArray((int)neighbors.size());
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)id, (DBIDRef)neighbor)) {
                    neighborhood.add((DBIDRef)neighbor);
                }
                neighbor.advance();
            }
            F[i][i] = 1.0;
            int nweight = -1 / neighborhood.size();
            DBIDMIter iter = neighborhood.iter();
            while (iter.valid()) {
                int pos = ids.binarySearch((DBIDRef)iter);
                assert (pos >= 0);
                F[pos][i] = nweight;
                iter.advance();
            }
            id.advance();
            ++i;
        }
        double[][] common = VMath.times((double[][])VMath.transposeTimesTranspose((double[][])X, (double[][])F), (double[][])F);
        double[][] b = VMath.times((double[][])VMath.inverse((double[][])VMath.times((double[][])common, (double[][])X)), (double[][])VMath.times((double[][])common, (double[][])Y));
        double[][] sigmaMat = VMath.times((double[][])F, (double[][])VMath.minusEquals((double[][])VMath.times((double[][])X, (double[][])b), (double[][])VMath.times((double[][])F, (double[][])Y)));
        double sigma_sum_square = VMath.normF((double[][])sigmaMat) / (double)(relationx.size() - 6 - 1);
        double norm = 1.0 / Math.sqrt(sigma_sum_square);
        double[][] E = VMath.timesEquals((double[][])VMath.times((double[][])F, (double[][])VMath.minus((double[][])Y, (double[][])VMath.times((double[][])X, (double[][])b))), (double)norm);
        DBIDVar worstid = DBIDUtil.newVar();
        double worstscore = Double.NEGATIVE_INFINITY;
        int i2 = 0;
        DBIDArrayMIter id2 = ids.iter();
        while (id2.valid()) {
            double err = VMath.squareSum((double[])VMath.getRow((double[][])E, (int)i2));
            if (err > worstscore) {
                worstscore = err;
                worstid.set((DBIDRef)id2);
            }
            id2.advance();
            ++i2;
        }
        return new Pair((Object)worstid, (Object)Math.sqrt(worstscore));
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID ALPHA_ID = new OptionID("glsbs.alpha", "Significance niveau");
        public static final OptionID K_ID = new OptionID("glsbs.k", "k nearest neighbors to use");
        private double alpha;
        private int k;
        protected Distance<? super V> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new DoubleParameter(ALPHA_ID).grab(config, x1 -> {
                this.alpha = x1;
            });
            new IntParameter(K_ID).grab(config, x2 -> {
                this.k = x2;
            });
        }

        public CTLuGLSBackwardSearchAlgorithm<V> make() {
            return new CTLuGLSBackwardSearchAlgorithm<V>(this.distance, this.k, this.alpha);
        }
    }
}

