/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.meta;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.scaling.ScalingFunction;
import elki.utilities.scaling.outlier.OutlierScaling;

public class RescaleMetaOutlierAlgorithm
implements OutlierAlgorithm {
    private Algorithm algorithm;
    private ScalingFunction scaling;

    public RescaleMetaOutlierAlgorithm(Algorithm algorithm, ScalingFunction scaling) {
        this.algorithm = algorithm;
        this.scaling = scaling;
    }

    @Override
    public OutlierResult autorun(Database database) {
        Object innerresult = this.algorithm.autorun(database);
        OutlierResult or = this.getOutlierResult(innerresult);
        DoubleRelation scores = or.getScores();
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        WritableDoubleDataStore scaledscores = DataStoreUtil.makeDoubleStorage((DBIDs)scores.getDBIDs(), (int)6);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer = scores.iterDBIDs();
        while (iditer.valid()) {
            double val = this.scaling.getScaled(scores.doubleValue((DBIDRef)iditer));
            scaledscores.putDouble((DBIDRef)iditer, val);
            minmax.put(val);
            iditer.advance();
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), this.scaling.getMin(), this.scaling.getMax());
        MaterializedDoubleRelation scoresult = new MaterializedDoubleRelation("Scaled Outlier", scores.getDBIDs(), (DoubleDataStore)scaledscores);
        OutlierResult result = new OutlierResult(meta, (DoubleRelation)scoresult);
        Metadata.hierarchyOf((Object)result).addChild(innerresult);
        return result;
    }

    private OutlierResult getOutlierResult(Object result) {
        It it = Metadata.hierarchyOf((Object)result).iterDescendantsSelf().filter(OutlierResult.class);
        if (it.valid()) {
            return (OutlierResult)it.get();
        }
        throw new IllegalStateException("Comparison algorithm expected at least one outlier result.");
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID SCALING_ID = new OptionID("metaoutlier.scaling", "Class to use as scaling function.");
        private Algorithm algorithm;
        private ScalingFunction scaling;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.ALGORITHM_ID, OutlierAlgorithm.class).grab(config, x -> {
                this.algorithm = x;
            });
            new ObjectParameter(SCALING_ID, ScalingFunction.class).grab(config, x -> {
                this.scaling = x;
            });
        }

        public RescaleMetaOutlierAlgorithm make() {
            return new RescaleMetaOutlierAlgorithm(this.algorithm, this.scaling);
        }
    }
}

