/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.meta;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.subspace.SubspaceEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.outlier.lof.LOF;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.pairs.Pair;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Random;

@Title(value="Feature Bagging for Outlier Detection")
@Reference(authors="A. Lazarevic, V. Kumar", title="Feature Bagging for Outlier Detection", booktitle="Proc. 11th ACM SIGKDD Int. Conf. on Knowledge Discovery in Data Mining", url="https://doi.org/10.1145/1081870.1081891", bibkey="DBLP:conf/kdd/LazarevicK05")
public class FeatureBagging
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(FeatureBagging.class);
    protected int num = 1;
    protected boolean breadth = false;
    private RandomFactory rnd;
    private int k;

    public FeatureBagging(int k, int num, boolean breadth, RandomFactory rnd) {
        this.k = k;
        this.num = num;
        this.breadth = breadth;
        this.rnd = rnd;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Relation<NumberVector> relation) {
        FiniteProgress cprog;
        int dbdim = RelationUtil.dimensionality(relation);
        int mindim = dbdim >> 1;
        int maxdim = dbdim - 1;
        Random rand = this.rnd.getSingleThreadedRandom();
        ArrayList<OutlierResult> results = new ArrayList<OutlierResult>(this.num);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("LOF iterations", this.num, LOG) : null;
        for (int i = 0; i < this.num; ++i) {
            long[] dimset = this.randomSubspace(dbdim, mindim, maxdim, rand);
            SubspaceEuclideanDistance df = new SubspaceEuclideanDistance(dimset);
            results.add(new LOF<NumberVector>(this.k, (Distance<NumberVector>)df).run(relation));
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DoubleMinMax minmax = new DoubleMinMax();
        if (this.breadth) {
            cprog = LOG.isVerbose() ? new FiniteProgress("Combining results", relation.size(), LOG) : null;
            Pair[] IDVectorOntoScoreVector = new Pair[results.size()];
            int i = 0;
            for (OutlierResult r : results) {
                IDVectorOntoScoreVector[i] = new Pair((Object)r.getOrdering().order(relation.getDBIDs()).iter(), (Object)r.getScores());
                ++i;
            }
            for (i = 0; i < relation.size(); ++i) {
                for (Pair pair : IDVectorOntoScoreVector) {
                    DBIDIter iter = (DBIDIter)pair.first;
                    if (iter.valid()) {
                        double score = ((DoubleRelation)pair.second).doubleValue((DBIDRef)iter);
                        if (Double.isNaN(scores.doubleValue((DBIDRef)iter))) {
                            scores.putDouble((DBIDRef)iter, score);
                            minmax.put(score);
                        }
                        iter.advance();
                        continue;
                    }
                    LOG.warning((CharSequence)"Incomplete result: Iterator does not contain |DB| DBIDs");
                }
                LOG.incrementProcessed((AbstractProgress)cprog);
            }
            LOG.ensureCompleted(cprog);
        } else {
            cprog = LOG.isVerbose() ? new FiniteProgress("Combining results", relation.size(), LOG) : null;
            DBIDIter iter = relation.iterDBIDs();
            while (iter.valid()) {
                double sum = 0.0;
                for (OutlierResult r : results) {
                    double s = r.getScores().doubleValue((DBIDRef)iter);
                    if (Double.isNaN(s)) continue;
                    sum += s;
                }
                scores.putDouble((DBIDRef)iter, sum);
                minmax.put(sum);
                LOG.incrementProcessed((AbstractProgress)cprog);
                iter.advance();
            }
            LOG.ensureCompleted(cprog);
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Feature bagging", relation.getDBIDs(), (DoubleDataStore)scores);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    private long[] randomSubspace(int alldim, int mindim, int maxdim, Random rand) {
        long[] dimset = BitsUtil.zero((int)alldim);
        int[] dims = new int[alldim];
        for (int d = 0; d < alldim; ++d) {
            dims[d] = d;
        }
        int subdim = mindim + rand.nextInt(maxdim - mindim);
        for (int d = 0; d < alldim - subdim; ++d) {
            int s = rand.nextInt(alldim - d);
            BitsUtil.setI((long[])dimset, (int)dims[s]);
            dims[s] = dims[alldim - d - 1];
        }
        return dimset;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID NUM_ID = new OptionID("fbagging.num", "The number of instances to use in the ensemble.");
        public static final OptionID BREADTH_ID = new OptionID("fbagging.breadth", "Use the breadth first combinations instead of the cumulative sum approach");
        public static final OptionID SEED_ID = new OptionID("fbagging.seed", "Specify a particular random seed.");
        protected int k = 2;
        protected int num = 1;
        protected boolean breadth = false;
        protected RandomFactory rnd;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(LOF.Par.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((IntParameter)new IntParameter(NUM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.num = x;
            });
            new Flag(BREADTH_ID).grab(config, x -> {
                this.breadth = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public FeatureBagging make() {
            return new FeatureBagging(this.k, this.num, this.breadth, this.rnd);
        }
    }
}

