/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.meta;

import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.datasource.parser.CSVReaderFormat;
import elki.logging.Logging;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FileUtil;
import elki.utilities.io.ParseUtil;
import elki.utilities.io.TokenizedReader;
import elki.utilities.io.Tokenizer;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.scaling.IdentityScaling;
import elki.utilities.scaling.ScalingFunction;
import elki.utilities.scaling.outlier.OutlierScaling;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalDoubleOutlierScore
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ExternalDoubleOutlierScore.class);
    public static final String COMMENT = "#";
    public static final String ID_PATTERN_DEFAULT = "^ID=";
    private URI file;
    private Pattern idpattern;
    private Pattern scorepattern;
    private ScalingFunction scaling;
    private boolean inverted = false;

    public ExternalDoubleOutlierScore(URI file, Pattern idpattern, Pattern scorepattern, boolean inverted, ScalingFunction scaling) {
        this.file = file;
        this.idpattern = idpattern;
        this.scorepattern = scorepattern;
        this.inverted = inverted;
        this.scaling = scaling;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.DBID});
    }

    public OutlierResult run(Relation<?> relation) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DoubleMinMax minmax = new DoubleMinMax();
        try (InputStream in = FileUtil.open((URI)this.file, (OpenOption[])new OpenOption[0]);
             TokenizedReader reader = CSVReaderFormat.DEFAULT_FORMAT.makeReader();){
            Tokenizer tokenizer = reader.getTokenizer();
            CharSequence buf = reader.getBuffer();
            Matcher mi = this.idpattern.matcher(buf);
            Matcher ms = this.scorepattern.matcher(buf);
            reader.reset(in);
            while (reader.nextLineExceptComments()) {
                Integer id = null;
                double score = Double.NaN;
                while (tokenizer.valid()) {
                    mi.region(tokenizer.getStart(), tokenizer.getEnd());
                    ms.region(tokenizer.getStart(), tokenizer.getEnd());
                    boolean mif = mi.find();
                    boolean msf = ms.find();
                    if (mif && msf) {
                        throw new AbortException("ID pattern and score pattern both match value: " + tokenizer.getSubstring());
                    }
                    if (mif) {
                        if (id != null) {
                            throw new AbortException("ID pattern matched twice: previous value " + id + " second value: " + tokenizer.getSubstring());
                        }
                        id = ParseUtil.parseIntBase10((CharSequence)buf, (int)mi.end(), (int)tokenizer.getEnd());
                    }
                    if (msf) {
                        if (!Double.isNaN(score)) {
                            throw new AbortException("Score pattern matched twice: previous value " + score + " second value: " + tokenizer.getSubstring());
                        }
                        score = ParseUtil.parseDouble((CharSequence)buf, (int)ms.end(), (int)tokenizer.getEnd());
                    }
                    tokenizer.advance();
                }
                if (id != null && !Double.isNaN(score)) {
                    scores.putDouble((DBIDRef)DBIDUtil.importInteger((int)id), score);
                    minmax.put(score);
                    continue;
                }
                if (id == null && Double.isNaN(score)) {
                    LOG.warning((CharSequence)("Line did not match either ID nor score nor comment: " + reader.getLineNumber()));
                    continue;
                }
                throw new AbortException("Line matched only ID or only SCORE patterns: " + reader.getLineNumber());
            }
        }
        catch (IOException e) {
            throw new AbortException("Could not load outlier scores: " + e.getMessage() + " when loading " + this.file, (Throwable)e);
        }
        BasicOutlierScoreMeta meta = this.inverted ? new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax()) : new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        MaterializedDoubleRelation scoresult = new MaterializedDoubleRelation("External Outlier", relation.getDBIDs(), (DoubleDataStore)scores);
        OutlierResult or = new OutlierResult(meta, (DoubleRelation)scoresult);
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        DoubleMinMax mm = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double val = scoresult.doubleValue((DBIDRef)iditer);
            val = this.scaling.getScaled(val);
            scores.putDouble((DBIDRef)iditer, val);
            mm.put(val);
            iditer.advance();
        }
        meta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax());
        return new OutlierResult(meta, (DoubleRelation)scoresult);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID FILE_ID = new OptionID("externaloutlier.file", "The file name containing the (external) outlier scores.");
        public static final OptionID ID_ID = new OptionID("externaloutlier.idpattern", "The pattern to match object ID prefix");
        public static final OptionID SCORE_ID = new OptionID("externaloutlier.scorepattern", "The pattern to match object score prefix");
        public static final OptionID SCALING_ID = new OptionID("externaloutlier.scaling", "Class to use as scaling function.");
        public static final OptionID INVERTED_ID = new OptionID("externaloutlier.inverted", "Flag to signal an inverted outlier score.");
        private URI file;
        private Pattern idpattern;
        private Pattern scorepattern;
        private ScalingFunction scaling;
        private boolean inverted = false;

        public void configure(Parameterization config) {
            new FileParameter(FILE_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                this.file = x;
            });
            new PatternParameter(ID_ID, ExternalDoubleOutlierScore.ID_PATTERN_DEFAULT).grab(config, x -> {
                this.idpattern = x;
            });
            new PatternParameter(SCORE_ID).grab(config, x -> {
                this.scorepattern = x;
            });
            new Flag(INVERTED_ID).grab(config, x -> {
                this.inverted = x;
            });
            new ObjectParameter(SCALING_ID, ScalingFunction.class, IdentityScaling.class).grab(config, x -> {
                this.scaling = x;
            });
        }

        public ExternalDoubleOutlierScore make() {
            return new ExternalDoubleOutlierScore(this.file, this.idpattern, this.scorepattern, this.inverted, this.scaling);
        }
    }
}

