/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.outlier.lof.LOF;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery 28(1)", url="https://doi.org/10.1007/s10618-012-0300-z", bibkey="DBLP:journals/datamine/SchubertZK14")
public class SimplifiedLOF<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimplifiedLOF.class);
    protected Distance<? super O> distance;
    protected int kplus;

    public SimplifiedLOF(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("Simplified LOF", 3) : null;
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).precomputed().kNNByDBID(this.kplus);
        LOG.beginStep(stepprog, 2, "Computing densities.");
        WritableDoubleDataStore dens = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        this.computeSimplifiedLRDs(ids, (KNNSearcher<DBIDRef>)knnq, dens);
        LOG.beginStep(stepprog, 3, "Computing SLOFs.");
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        this.computeSimplifiedLOFs(ids, (KNNSearcher<DBIDRef>)knnq, dens, lofs, lofminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Simplified Local Outlier Factor", ids, (DoubleDataStore)lofs);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult result = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        return result;
    }

    private void computeSimplifiedLRDs(DBIDs ids, KNNSearcher<DBIDRef> knnq, WritableDoubleDataStore lrds) {
        FiniteProgress lrdsProgress = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNN((Object)iter, this.kplus);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)iter)) {
                    sum += neighbor.doubleValue();
                    ++count;
                }
                neighbor.advance();
            }
            double lrd = sum > 0.0 ? (double)count / sum : Double.POSITIVE_INFINITY;
            lrds.putDouble((DBIDRef)iter, lrd);
            LOG.incrementProcessed((AbstractProgress)lrdsProgress);
            iter.advance();
        }
        LOG.ensureCompleted(lrdsProgress);
    }

    private void computeSimplifiedLOFs(DBIDs ids, KNNSearcher<DBIDRef> knnq, WritableDoubleDataStore slrds, WritableDoubleDataStore lofs, DoubleMinMax lofminmax) {
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("Simplified LOF scores", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double lof;
            double lrdp = slrds.doubleValue((DBIDRef)iter);
            KNNList neighbors = knnq.getKNN((Object)iter, this.kplus);
            if (!Double.isInfinite(lrdp)) {
                double sum = 0.0;
                int count = 0;
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)iter)) {
                        double val = slrds.doubleValue((DBIDRef)neighbor);
                        sum += val;
                        ++count;
                        if (Double.isInfinite(val)) break;
                    }
                    neighbor.advance();
                }
                lof = sum / (lrdp * (double)count);
            } else {
                lof = 1.0;
            }
            lofs.putDouble((DBIDRef)iter, lof);
            lofminmax.put(lof);
            LOG.incrementProcessed((AbstractProgress)progressLOFs);
            iter.advance();
        }
        LOG.ensureCompleted(progressLOFs);
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;
        protected int k = 2;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(LOF.Par.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public SimplifiedLOF<O> make() {
            return new SimplifiedLOF<O>(this.distance, this.k);
        }
    }
}

