/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.knn.PreprocessorKNNQuery;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.index.preprocessed.knn.KNNChangeEvent;
import elki.index.preprocessed.knn.KNNListener;
import elki.index.preprocessed.knn.MaterializeKNNAndRKNNPreprocessor;
import elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import elki.logging.Logging;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.outlier.lof.FlexibleLOF;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.pairs.Pair;

public class OnlineLOF<O>
extends FlexibleLOF<O> {
    private static final Logging LOG = Logging.getLogger(OnlineLOF.class);

    public OnlineLOF(int krefer, int kreach, Distance<? super O> neighborhoodDistance, Distance<? super O> reachabilityDistance) {
        super(krefer, kreach, neighborhoodDistance, reachabilityDistance);
    }

    @Override
    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("OnlineLOF", 3) : null;
        Pair<Pair<KNNSearcher<DBIDRef>, KNNSearcher<DBIDRef>>, Pair<RKNNSearcher<DBIDRef>, RKNNSearcher<DBIDRef>>> queries = this.getKNNAndRkNNQueries(relation, stepprog);
        KNNSearcher kNNRefer = (KNNSearcher)((Pair)queries.getFirst()).getFirst();
        KNNSearcher kNNReach = (KNNSearcher)((Pair)queries.getFirst()).getSecond();
        RKNNSearcher rkNNRefer = (RKNNSearcher)((Pair)queries.getSecond()).getFirst();
        RKNNSearcher rkNNReach = (RKNNSearcher)((Pair)queries.getSecond()).getSecond();
        FlexibleLOF.LOFResult lofResult = super.doRunInTime(relation.getDBIDs(), (KNNSearcher<DBIDRef>)kNNRefer, (KNNSearcher<DBIDRef>)kNNReach, stepprog);
        lofResult.setRkNNRefer((RKNNSearcher<DBIDRef>)rkNNRefer);
        lofResult.setRkNNReach((RKNNSearcher<DBIDRef>)rkNNReach);
        LOFKNNListener l = new LOFKNNListener(lofResult);
        ((MaterializeKNNPreprocessor)((PreprocessorKNNQuery)lofResult.getKNNRefer()).getPreprocessor()).addKNNListener((KNNListener)l);
        ((MaterializeKNNPreprocessor)((PreprocessorKNNQuery)lofResult.getKNNReach()).getPreprocessor()).addKNNListener((KNNListener)l);
        return lofResult.getResult();
    }

    private Pair<Pair<KNNSearcher<DBIDRef>, KNNSearcher<DBIDRef>>, Pair<RKNNSearcher<DBIDRef>, RKNNSearcher<DBIDRef>>> getKNNAndRkNNQueries(Relation<O> relation, StepProgress stepprog) {
        DistanceQuery drefQ = new QueryBuilder(relation, this.referenceDistance).distanceQuery();
        KNNSearcher kNNRefer = new QueryBuilder(drefQ).optimizedOnly().kNNByDBID(this.krefer);
        RKNNSearcher rkNNRefer = new QueryBuilder(drefQ).optimizedOnly().rKNNByDBID(this.krefer);
        if (kNNRefer == null || rkNNRefer == null) {
            if (stepprog != null) {
                stepprog.beginStep(1, "Materializing neighborhood w.r.t. reference neighborhood distance function.", LOG);
            }
            MaterializeKNNAndRKNNPreprocessor preproc = new MaterializeKNNAndRKNNPreprocessor(relation, this.referenceDistance, this.krefer);
            kNNRefer = preproc.kNNByDBID(drefQ, this.krefer, 0);
            rkNNRefer = preproc.rkNNByDBID(drefQ, this.krefer, 0);
            Metadata.hierarchyOf(relation).addChild((Object)preproc);
        } else if (stepprog != null) {
            stepprog.beginStep(1, "Optimized neighborhood w.r.t. reference neighborhood distance function provided by database.", LOG);
        }
        DistanceQuery dreachQ = new QueryBuilder(relation, this.reachabilityDistance).distanceQuery();
        KNNSearcher kNNReach = new QueryBuilder(dreachQ).optimizedOnly().kNNByDBID(this.kreach);
        RKNNSearcher rkNNReach = new QueryBuilder(dreachQ).optimizedOnly().rKNNByDBID(this.kreach);
        if (kNNReach == null || rkNNReach == null) {
            if (stepprog != null) {
                stepprog.beginStep(2, "Materializing neighborhood w.r.t. reachability distance function.", LOG);
            }
            MaterializeKNNAndRKNNPreprocessor preproc = new MaterializeKNNAndRKNNPreprocessor(relation, this.reachabilityDistance, this.kreach);
            kNNReach = preproc.kNNByDBID(dreachQ, this.kreach, 0);
            rkNNReach = preproc.rkNNByDBID(dreachQ, this.kreach, 0);
            Metadata.hierarchyOf(relation).addChild((Object)preproc);
        }
        Pair kNNPair = new Pair((Object)kNNRefer, (Object)kNNReach);
        Pair rkNNPair = new Pair((Object)rkNNRefer, (Object)rkNNReach);
        return new Pair((Object)kNNPair, (Object)rkNNPair);
    }

    public static class Par<O>
    extends FlexibleLOF.Par<O> {
        @Override
        public OnlineLOF<O> make() {
            return new OnlineLOF(this.kreach, this.krefer, this.distance, this.reachabilityDistance);
        }
    }

    private class LOFKNNListener
    implements KNNListener {
        private KNNChangeEvent firstEventReceived;
        private FlexibleLOF.LOFResult<O> lofResult;

        public LOFKNNListener(FlexibleLOF.LOFResult<O> lofResult) {
            this.lofResult = lofResult;
        }

        public void kNNsChanged(KNNChangeEvent e) {
            AbstractMaterializeKNNPreprocessor p1 = ((PreprocessorKNNQuery)this.lofResult.getKNNRefer()).getPreprocessor();
            AbstractMaterializeKNNPreprocessor p2 = ((PreprocessorKNNQuery)this.lofResult.getKNNReach()).getPreprocessor();
            if (this.firstEventReceived == null) {
                if (e.getSource().equals(p1) && e.getSource().equals(p2)) {
                    this.kNNsChanged(e, e);
                } else {
                    this.firstEventReceived = e;
                }
            } else if (e.getSource().equals(p1) && this.firstEventReceived.getSource().equals(p2)) {
                this.kNNsChanged(e, this.firstEventReceived);
                this.firstEventReceived = null;
            } else if (e.getSource().equals(p2) && this.firstEventReceived.getSource().equals(p1)) {
                this.kNNsChanged(this.firstEventReceived, e);
                this.firstEventReceived = null;
            } else {
                throw new UnsupportedOperationException("Event sources do not fit!");
            }
        }

        private void kNNsChanged(KNNChangeEvent e1, KNNChangeEvent e2) {
            if (!e1.getType().equals((Object)e2.getType())) {
                throw new UnsupportedOperationException("Event types do not fit: " + e1.getType() + " != " + e2.getType());
            }
            if (!e1.getObjects().equals(e2.getObjects())) {
                throw new UnsupportedOperationException("Objects do not fit: " + e1.getObjects() + " != " + e2.getObjects());
            }
            if (e1.getType().equals((Object)KNNChangeEvent.Type.DELETE)) {
                this.kNNsRemoved(e1.getObjects(), e1.getUpdates(), e2.getUpdates(), this.lofResult);
            } else if (e1.getType().equals((Object)KNNChangeEvent.Type.INSERT)) {
                this.kNNsInserted(e1.getObjects(), e1.getUpdates(), e2.getUpdates(), this.lofResult);
            } else {
                throw new UnsupportedOperationException("Unsupported event type: " + e1.getType());
            }
        }

        private void kNNsInserted(DBIDs insertions, DBIDs updates1, DBIDs updates2, FlexibleLOF.LOFResult<O> lofResult) {
            StepProgress stepprog;
            StepProgress stepProgress = stepprog = LOG.isVerbose() ? new StepProgress(3) : null;
            if (stepprog != null) {
                stepprog.beginStep(1, "Recompute LRDs.", LOG);
            }
            ModifiableDBIDs lrd_ids = DBIDUtil.union((DBIDs)insertions, (DBIDs)updates2);
            HashSetModifiableDBIDs affected_lrd_id_candidates = DBIDUtil.newHashSet((int)(lrd_ids.size() * OnlineLOF.this.kreach));
            DBIDIter it = lrd_ids.iter();
            while (it.valid()) {
                affected_lrd_id_candidates.addDBIDs((DBIDs)lofResult.getRkNNReach().getRKNN((Object)it, OnlineLOF.this.kreach));
                it.advance();
            }
            affected_lrd_id_candidates.addDBIDs((DBIDs)lrd_ids);
            WritableDoubleDataStore new_lrds = DataStoreUtil.makeDoubleStorage((DBIDs)affected_lrd_id_candidates, (int)3);
            OnlineLOF.this.computeLRDs(lofResult.getKNNReach(), (DBIDs)affected_lrd_id_candidates, new_lrds);
            ArrayModifiableDBIDs affected_lrd_ids = DBIDUtil.newArray((int)affected_lrd_id_candidates.size());
            DBIDMIter iter = affected_lrd_id_candidates.iter();
            while (iter.valid()) {
                double new_lrd = new_lrds.doubleValue((DBIDRef)iter);
                if (new_lrd != lofResult.getLrds().doubleValue((DBIDRef)iter)) {
                    lofResult.getLrds().putDouble((DBIDRef)iter, new_lrd);
                    affected_lrd_ids.add((DBIDRef)iter);
                }
                iter.advance();
            }
            if (stepprog != null) {
                stepprog.beginStep(2, "Recompute LOFS.", LOG);
            }
            HashSetModifiableDBIDs affected_lof_ids = DBIDUtil.newHashSet((int)(affected_lrd_ids.size() * OnlineLOF.this.kreach));
            DBIDArrayMIter it2 = affected_lrd_ids.iter();
            while (it2.valid()) {
                affected_lof_ids.addDBIDs((DBIDs)lofResult.getRkNNRefer().getRKNN((Object)it2, OnlineLOF.this.kreach));
                it2.advance();
            }
            affected_lof_ids.addDBIDs((DBIDs)affected_lrd_ids);
            affected_lof_ids.addDBIDs(insertions);
            affected_lof_ids.addDBIDs(updates1);
            this.recomputeLOFs((DBIDs)affected_lof_ids, lofResult);
            if (stepprog != null) {
                stepprog.beginStep(3, "Inform listeners.", LOG);
            }
            Metadata.of((Object)lofResult.getResult()).notifyChanged();
            LOG.setCompleted(stepprog);
        }

        private void kNNsRemoved(DBIDs deletions, DBIDs updates1, DBIDs updates2, FlexibleLOF.LOFResult<O> lofResult) {
            StepProgress stepprog;
            StepProgress stepProgress = stepprog = LOG.isVerbose() ? new StepProgress(4) : null;
            if (stepprog != null) {
                stepprog.beginStep(1, "Delete old LRDs and LOFs.", LOG);
            }
            DBIDIter iter = deletions.iter();
            while (iter.valid()) {
                lofResult.getLrds().delete((DBIDRef)iter);
                lofResult.getLofs().delete((DBIDRef)iter);
                iter.advance();
            }
            if (stepprog != null) {
                stepprog.beginStep(2, "Recompute LRDs.", LOG);
            }
            HashSetModifiableDBIDs affected_lrd_id_candidates = DBIDUtil.newHashSet((int)(updates2.size() * OnlineLOF.this.kreach));
            DBIDIter it = updates2.iter();
            while (it.valid()) {
                affected_lrd_id_candidates.addDBIDs((DBIDs)lofResult.getRkNNReach().getRKNN((Object)it, OnlineLOF.this.kreach));
                it.advance();
            }
            affected_lrd_id_candidates.addDBIDs(updates2);
            WritableDoubleDataStore new_lrds = DataStoreUtil.makeDoubleStorage((DBIDs)affected_lrd_id_candidates, (int)3);
            OnlineLOF.this.computeLRDs(lofResult.getKNNReach(), (DBIDs)affected_lrd_id_candidates, new_lrds);
            ArrayModifiableDBIDs affected_lrd_ids = DBIDUtil.newArray((int)affected_lrd_id_candidates.size());
            DBIDMIter iter2 = affected_lrd_id_candidates.iter();
            while (iter2.valid()) {
                double new_lrd = new_lrds.doubleValue((DBIDRef)iter2);
                if (new_lrd != lofResult.getLrds().doubleValue((DBIDRef)iter2)) {
                    lofResult.getLrds().putDouble((DBIDRef)iter2, new_lrd);
                    affected_lrd_ids.add((DBIDRef)iter2);
                }
                iter2.advance();
            }
            if (stepprog != null) {
                stepprog.beginStep(3, "Recompute LOFS.", LOG);
            }
            HashSetModifiableDBIDs affected_lof_ids = DBIDUtil.newHashSet((int)(affected_lrd_ids.size() * OnlineLOF.this.krefer));
            DBIDArrayMIter it2 = affected_lrd_ids.iter();
            while (it2.valid()) {
                affected_lof_ids.addDBIDs((DBIDs)lofResult.getRkNNRefer().getRKNN((Object)it2, OnlineLOF.this.krefer));
                it2.advance();
            }
            affected_lof_ids.addDBIDs((DBIDs)affected_lrd_ids);
            affected_lof_ids.addDBIDs(updates1);
            this.recomputeLOFs((DBIDs)affected_lof_ids, lofResult);
            if (stepprog != null) {
                stepprog.beginStep(4, "Inform listeners.", LOG);
            }
            Metadata.of((Object)lofResult.getResult()).notifyChanged();
            LOG.setCompleted(stepprog);
        }

        private void recomputeLOFs(DBIDs ids, FlexibleLOF.LOFResult<O> lofResult) {
            WritableDoubleDataStore new_lofs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
            DoubleMinMax new_lofminmax = new DoubleMinMax();
            OnlineLOF.this.computeLOFs(lofResult.getKNNRefer(), ids, (DoubleDataStore)lofResult.getLrds(), new_lofs, new_lofminmax);
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                lofResult.getLofs().putDouble((DBIDRef)iter, new_lofs.doubleValue((DBIDRef)iter));
                iter.advance();
            }
            if (new_lofminmax.isValid()) {
                BasicOutlierScoreMeta scoreMeta;
                if (lofResult.getResult().getOutlierMeta().getActualMaximum() < new_lofminmax.getMax()) {
                    scoreMeta = (BasicOutlierScoreMeta)lofResult.getResult().getOutlierMeta();
                    scoreMeta.setActualMaximum(new_lofminmax.getMax());
                }
                if (lofResult.getResult().getOutlierMeta().getActualMinimum() > new_lofminmax.getMin()) {
                    scoreMeta = (BasicOutlierScoreMeta)lofResult.getResult().getOutlierMeta();
                    scoreMeta.setActualMinimum(new_lofminmax.getMin());
                }
            }
        }
    }
}

