/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.intrinsic;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.math.statistics.intrinsicdimensionality.ALIDEstimator;
import elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="IDOS: Intrinsic Dimensional Outlier Score")
@Reference(authors="Jonathan von Br\u00fcnken, Michael E. Houle, Arthur Zimek", title="Intrinsic Dimensional Outlier Detection in High-Dimensional Data", booktitle="NII Technical Report (NII-2015-003E)", url="http://www.nii.ac.jp/TechReports/15-003E.html", bibkey="tr/nii/BrunkenHZ15")
public class IDOS<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(IDOS.class);
    protected Distance<? super O> distance;
    protected int k_c;
    protected int k_r;
    protected IntrinsicDimensionalityEstimator<? super O> estimator;

    public IDOS(Distance<? super O> distance, IntrinsicDimensionalityEstimator<? super O> estimator, int kc, int kr) {
        this.distance = distance;
        this.estimator = estimator;
        this.k_c = kc;
        this.k_r = kr;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog;
        StepProgress stepProgress = stepprog = LOG.isVerbose() ? new StepProgress("IDOS", 3) : null;
        if (stepprog != null) {
            stepprog.beginStep(1, "Precomputing neighborhoods", LOG);
        }
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        DistanceQuery distQ = qb.distanceQuery();
        KNNSearcher knnQ = qb.precomputed().kNNByDBID(Math.max(this.k_c, this.k_r) + 1);
        DBIDs ids = relation.getDBIDs();
        if (stepprog != null) {
            stepprog.beginStep(2, "Computing intrinsic dimensionalities", LOG);
        }
        DoubleDataStore intDims = this.computeIDs(ids, (KNNSearcher<DBIDRef>)knnQ, distQ);
        if (stepprog != null) {
            stepprog.beginStep(3, "Computing IDOS scores", LOG);
        }
        DoubleMinMax idosminmax = new DoubleMinMax();
        DoubleDataStore ldms = this.computeIDOS(ids, (KNNSearcher<DBIDRef>)knnQ, intDims, idosminmax);
        if (stepprog != null) {
            stepprog.setCompleted(LOG);
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Intrinsic Dimensionality Outlier Score", ids, ldms);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(idosminmax.getMin(), idosminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    protected DoubleDataStore computeIDs(DBIDs ids, KNNSearcher<DBIDRef> knnQ, DistanceQuery<O> distQ) {
        WritableDoubleDataStore intDims = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Intrinsic dimensionality", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double id = 0.0;
            try {
                id = this.estimator.estimate(knnQ, distQ, (DBIDRef)iter, this.k_c + 1);
            }
            catch (ArithmeticException e) {
                id = 0.0;
            }
            intDims.putDouble((DBIDRef)iter, id);
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        return intDims;
    }

    protected DoubleDataStore computeIDOS(DBIDs ids, KNNSearcher<DBIDRef> knnQ, DoubleDataStore intDims, DoubleMinMax idosminmax) {
        WritableDoubleDataStore ldms = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("ID Outlier Scores for objects", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double id_q;
            KNNList neighbors = knnQ.getKNN((Object)iter, this.k_r);
            double sum = 0.0;
            int cnt = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iter, (DBIDRef)neighbor)) {
                    double id = intDims.doubleValue((DBIDRef)neighbor);
                    sum += id > 0.0 ? 1.0 / id : 0.0;
                    if (++cnt == this.k_r) break;
                }
                neighbor.advance();
            }
            double idos = (id_q = intDims.doubleValue((DBIDRef)iter)) > 0.0 ? id_q * sum / (double)cnt : 0.0;
            ldms.putDouble((DBIDRef)iter, idos);
            idosminmax.put(idos);
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        return ldms;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID ESTIMATOR_ID = new OptionID("idos.estimator", "Estimator of intrinsic dimensionality.");
        public static final OptionID KR_ID = new OptionID("idos.kr", "Reference set size.");
        public static final OptionID KC_ID = new OptionID("idos.kc", "Context set size (ID estimation).");
        protected Distance<? super O> distance;
        protected IntrinsicDimensionalityEstimator<? super O> estimator;
        protected int k_c = 20;
        protected int k_r = 20;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new ObjectParameter(ESTIMATOR_ID, IntrinsicDimensionalityEstimator.class, ALIDEstimator.class).grab(config, x -> {
                this.estimator = x;
            });
            ((IntParameter)new IntParameter(KC_ID).addConstraint((ParameterConstraint)new GreaterEqualConstraint(5))).grab(config, x -> {
                this.k_c = x;
            });
            ((IntParameter)new IntParameter(KR_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.k_r = x;
            });
        }

        public IDOS<O> make() {
            return new IDOS<O>(this.distance, this.estimator, this.k_c, this.k_r);
        }
    }
}

