/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance.parallel;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.outlier.distance.KNNWeightOutlier;
import elki.outlier.distance.parallel.KNNWeightProcessor;
import elki.parallel.ParallelExecutor;
import elki.parallel.processor.DoubleMinMaxProcessor;
import elki.parallel.processor.KNNProcessor;
import elki.parallel.processor.Processor;
import elki.parallel.processor.WriteDoubleDataStoreProcessor;
import elki.parallel.variables.SharedDouble;
import elki.parallel.variables.SharedObject;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery 28(1)", url="https://doi.org/10.1007/s10618-012-0300-z", bibkey="DBLP:journals/datamine/SchubertZK14")
public class ParallelKNNWeightOutlier<O>
implements OutlierAlgorithm {
    protected Distance<? super O> distance;
    protected int kplus;

    public ParallelKNNWeightOutlier(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore store = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        KNNProcessor knnm = new KNNProcessor(this.kplus, () -> qb.kNNByDBID(this.kplus));
        SharedObject knnv = new SharedObject();
        knnm.connectKNNOutput(knnv);
        KNNWeightProcessor kdistm = new KNNWeightProcessor(this.kplus);
        SharedDouble kdistv = new SharedDouble();
        kdistm.connectKNNInput((SharedObject<? extends KNNList>)knnv);
        kdistm.connectOutput(kdistv);
        WriteDoubleDataStoreProcessor storem = new WriteDoubleDataStoreProcessor(store);
        storem.connectInput(kdistv);
        DoubleMinMaxProcessor mmm = new DoubleMinMaxProcessor();
        mmm.connectInput(kdistv);
        ParallelExecutor.run((DBIDs)ids, (Processor[])new Processor[]{knnm, kdistm, storem, mmm});
        DoubleMinMax minmax = mmm.getMinMax();
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("kNN weight Outlier Score", ids, (DoubleDataStore)store);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;
        protected int k;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new IntParameter(KNNWeightOutlier.Par.K_ID).grab(config, x -> {
                this.k = x;
            });
        }

        public ParallelKNNWeightOutlier<O> make() {
            return new ParallelKNNWeightOutlier<O>(this.distance, this.k);
        }
    }
}

