/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="B. Yu, M. Song, L. Wang", title="Local Isolation Coefficient-Based Outlier Mining Algorithm", booktitle="Int. Conf. on Information Technology and Computer Science (ITCS) 2009", url="https://doi.org/10.1109/ITCS.2009.230", bibkey="doi:10.1109/ITCS.2009.230")
public class LocalIsolationCoefficient<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LocalIsolationCoefficient.class);
    private int kplus;
    protected Distance<? super O> distance;

    public LocalIsolationCoefficient(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.kplus);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Compute Local Isolation Coefficients", relation.size(), LOG) : null;
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore lic_score = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList knn = knnQuery.getKNN((Object)iditer, this.kplus);
            double skn = 0.0;
            int i = 0;
            DoubleDBIDListIter neighbor = knn.iter();
            while (neighbor.getOffset() < this.kplus && neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iditer, (DBIDRef)neighbor)) {
                    skn += neighbor.doubleValue();
                    ++i;
                }
                neighbor.advance();
            }
            double lic = knn.getKNNDistance() + (i > 0 ? skn / (double)i : 0.0);
            lic_score.putDouble((DBIDRef)iditer, lic);
            minmax.put(lic);
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        MaterializedDoubleRelation res = new MaterializedDoubleRelation("Local Isolation Coefficient", relation.getDBIDs(), (DoubleDataStore)lic_score);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(meta, (DoubleRelation)res);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("lic.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected Distance<? super O> distance;
        protected int k = 0;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public LocalIsolationCoefficient<O> make() {
            return new LocalIsolationCoefficient<O>(this.distance, this.k);
        }
    }
}

