/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.outlier.distance.SOS;
import elki.outlier.intrinsic.ISOS;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="KNNSOS: k-Nearest-Neighbor Stochastic Outlier Selection")
@References(value={@Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP 2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17"), @Reference(authors="J. Janssens, F. Husz\u00e1r, E. Postma, J. van den Herik", title="Stochastic Outlier Selection", booktitle="TiCC TR 2012\u2013001", url="https://www.tilburguniversity.edu/upload/b7bac5b2-9b00-402a-9261-7849aa019fbb_sostr.pdf", bibkey="tr/tilburg/JanssensHPv12")})
public class KNNSOS<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNSOS.class);
    protected Distance<? super O> distance;
    protected int k;
    protected double phi = 0.01;

    public KNNSOS(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.k = k;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        int k1 = this.k + 1;
        double perplexity = (double)this.k / 3.0;
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).kNNByDBID(k1);
        double logPerp = perplexity > 1.0 ? FastMath.log((double)perplexity) : 0.1;
        double[] p = new double[this.k + 10];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("KNNSOS scores", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)30, (double)1.0);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            KNNList knns = knnq.getKNN((Object)it, k1);
            if (p.length < knns.size() + 1) {
                p = new double[knns.size() + 10];
            }
            DoubleDBIDListIter ki = knns.iter();
            SOS.computePi((DBIDRef)it, ki, p, perplexity, logPerp);
            double s = SOS.sumOfProbabilities(it, (DBIDArrayIter)ki, p);
            if (s > 0.0) {
                ISOS.nominateNeighbors(it, (DBIDArrayIter)ki, p, 1.0 / s, scores);
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        DoubleMinMax minmax = ISOS.transformScores(scores, relation.getDBIDs(), logPerp, this.phi);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("kNN Stoachastic Outlier Selection", relation.getDBIDs(), (DoubleDataStore)scores);
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(minmax.getMin(), minmax.getMax(), 0.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID KNN_ID = new OptionID("sos.k", "Number of neighbors to use. Should be about 3x the desired perplexity.");
        protected Distance<? super O> distance;
        protected int k = 15;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(KNN_ID, 15).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public KNNSOS<O> make() {
            return new KNNSOS<O>(this.distance, this.k);
        }
    }
}

