/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="KNNDD: k-Nearest Neighbor Data Description")
@Reference(authors="D. de Ridder, D. M. J. Tax, R. P. W. Duin", title="An experimental comparison of one-class classification methods", booktitle="Proc. 4th Ann. Conf. Advanced School for Computing and Imaging (ASCI'98)", url="http://prlab.tudelft.nl/sites/default/files/asci_98.pdf", bibkey="conf/asci/deRidderTD98")
public class KNNDD<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNDD.class);
    protected Distance<? super O> distance;
    protected int kplus;

    public KNNDD(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.kplus);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("kNN distance for objects", relation.size(), LOG) : null;
        WritableDoubleDataStore knnDist = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3);
        WritableDBIDDataStore neighbor = DataStoreUtil.makeDBIDStorage((DBIDs)relation.getDBIDs(), (int)3);
        DBIDVar var = DBIDUtil.newVar();
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            KNNList knn = knnQuery.getKNN((Object)it, this.kplus);
            knnDist.putDouble((DBIDRef)it, knn.getKNNDistance());
            neighbor.put((DBIDRef)it, (DBIDRef)knn.assignVar(knn.size() - 1, var));
            LOG.incrementProcessed((AbstractProgress)prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        prog = LOG.isVerbose() ? new FiniteProgress("kNN distance descriptor", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)30);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter it2 = relation.iterDBIDs();
        while (it2.valid()) {
            double d = knnDist.doubleValue((DBIDRef)it2);
            double nd = knnDist.doubleValue((DBIDRef)neighbor.assignVar((DBIDRef)it2, var));
            double knndd = nd > 0.0 ? d / nd : (d > 0.0 ? Double.POSITIVE_INFINITY : 1.0);
            scores.put((DBIDRef)it2, knndd);
            minmax.put(knndd);
            LOG.incrementProcessed((AbstractProgress)prog);
            it2.advance();
        }
        LOG.ensureCompleted(prog);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("kNN Data Descriptor", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("knndd.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected Distance<? super O> distance;
        protected int k = 0;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public KNNDD<O> make() {
            return new KNNDD<O>(this.distance, this.k);
        }
    }
}

