/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.outlier.distance.AbstractDBOutlier;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="DBOD: Distance Based Outlier Detection")
@Description(value="If the D-neighborhood of an object contains only very few objects (less than (1-p) percent of the data) this object is flagged as an outlier")
@Reference(authors="E. M. Knorr, R. T. Ng", title="Algorithms for Mining Distance-Based Outliers in Large Datasets", booktitle="Proc. Int. Conf. on Very Large Databases (VLDB'98)", url="http://www.vldb.org/conf/1998/p392.pdf", bibkey="DBLP:conf/vldb/KnorrN98")
public class DBOutlierDetection<O>
extends AbstractDBOutlier<O> {
    private static final Logging LOG = Logging.getLogger(DBOutlierDetection.class);
    private double p;

    public DBOutlierDetection(Distance<? super O> distance, double d, double p) {
        super(distance, d);
        this.p = p;
    }

    @Override
    protected DoubleDataStore computeOutlierScores(Relation<O> relation, double d) {
        FiniteProgress prog;
        int m = (int)Math.floor((double)relation.size() * (1.0 - this.p));
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        DistanceQuery distFunc = qb.distanceQuery();
        KNNSearcher knnQuery = qb.optimizedOnly().kNNByDBID(m);
        RangeSearcher rangeQuery = knnQuery == null ? qb.rangeByDBID(d) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)distFunc.getRelation().getDBIDs(), (int)4);
        FiniteProgress finiteProgress = prog = LOG.isVerbose() ? new FiniteProgress("DBOutlier detection", distFunc.getRelation().size(), LOG) : null;
        if (knnQuery != null) {
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose((CharSequence)("Using kNN query: " + knnQuery.toString()));
            }
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                KNNList knns = knnQuery.getKNN((Object)iditer, m);
                scores.putDouble((DBIDRef)iditer, knns.getKNNDistance() > d ? 1.0 : 0.0);
                LOG.incrementProcessed((AbstractProgress)prog);
                iditer.advance();
            }
        } else if (rangeQuery != null) {
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose((CharSequence)("Using range query: " + rangeQuery.toString()));
            }
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                DoubleDBIDList neighbors = rangeQuery.getRange((Object)iditer, d);
                scores.putDouble((DBIDRef)iditer, neighbors.size() < m ? 1.0 : 0.0);
                LOG.incrementProcessed((AbstractProgress)prog);
                iditer.advance();
            }
        } else {
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                double currentDistance;
                int count = 0;
                DBIDIter iterator = relation.iterDBIDs();
                while (iterator.valid() && (!((currentDistance = distFunc.distance((DBIDRef)iditer, (DBIDRef)iterator)) <= d) || ++count < m)) {
                    iterator.advance();
                }
                scores.putDouble((DBIDRef)iditer, count < m ? 1.0 : 0.0);
                LOG.incrementProcessed((AbstractProgress)prog);
                iditer.advance();
            }
        }
        LOG.ensureCompleted(prog);
        return scores;
    }

    public static class Par<O>
    extends AbstractDBOutlier.Par<O> {
        public static final OptionID P_ID = new OptionID("dbod.p", "minimum fraction of objects that must be outside the D-neighborhood of an outlier");
        protected double p = 0.0;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE)).grab(config, x -> {
                this.p = x;
            });
        }

        public DBOutlierDetection<O> make() {
            return new DBOutlierDetection(this.distance, this.d, this.p);
        }
    }
}

