/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.anglebased;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.math.DoubleMinMax;
import elki.math.MeanVariance;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.similarity.Similarity;
import elki.similarity.kernel.KernelMatrix;
import elki.similarity.kernel.PolynomialKernel;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="ABOD: Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="Hans-Peter Kriegel, Matthias Schubert, Arthur Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining (KDD'08)", url="https://doi.org/10.1145/1401890.1401946", bibkey="DBLP:conf/kdd/KriegelSZ08")
public class ABOD<V extends NumberVector>
implements OutlierAlgorithm {
    protected Similarity<? super V> kernelFunction;

    public ABOD(Similarity<? super V> kernelFunction) {
        this.kernelFunction = kernelFunction;
    }

    public OutlierResult run(Relation<V> relation) {
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        SimilarityQuery sq = new QueryBuilder(relation, this.kernelFunction).similarityQuery();
        KernelMatrix kernelMatrix = new KernelMatrix(sq, relation, (DBIDs)ids);
        WritableDoubleDataStore abodvalues = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax minmaxabod = new DoubleMinMax();
        MeanVariance s = new MeanVariance();
        DBIDArrayIter pA = ids.iter();
        DBIDArrayIter pB = ids.iter();
        DBIDArrayIter pC = ids.iter();
        while (pA.valid()) {
            double abof = this.computeABOF(kernelMatrix, (DBIDRef)pA, pB, pC, s);
            minmaxabod.put(abof);
            abodvalues.putDouble((DBIDRef)pA, abof);
            pA.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Angle-Based Outlier Degree", relation.getDBIDs(), (DoubleDataStore)abodvalues);
        InvertedOutlierScoreMeta scoreMeta = new InvertedOutlierScoreMeta(minmaxabod.getMin(), minmaxabod.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    protected double computeABOF(KernelMatrix kernelMatrix, DBIDRef pA, DBIDArrayIter pB, DBIDArrayIter pC, MeanVariance s) {
        s.reset();
        double simAA = kernelMatrix.getSimilarity(pA, pA);
        pB.seek(0);
        while (pB.valid()) {
            double simAB;
            double simBB;
            double sqdAB;
            if (!DBIDUtil.equal((DBIDRef)pB, (DBIDRef)pA) && (sqdAB = simAA + (simBB = kernelMatrix.getSimilarity((DBIDRef)pB, (DBIDRef)pB)) - (simAB = kernelMatrix.getSimilarity(pA, (DBIDRef)pB)) - simAB) > 0.0) {
                pC.seek(pB.getOffset() + 1);
                while (pC.valid()) {
                    double simAC;
                    double simCC;
                    double sqdAC;
                    if (!DBIDUtil.equal((DBIDRef)pC, (DBIDRef)pA) && (sqdAC = simAA + (simCC = kernelMatrix.getSimilarity((DBIDRef)pC, (DBIDRef)pC)) - (simAC = kernelMatrix.getSimilarity(pA, (DBIDRef)pC)) - simAC) > 0.0) {
                        double simBC = kernelMatrix.getSimilarity((DBIDRef)pB, (DBIDRef)pC);
                        double numerator = simBC - simAB - simAC + simAA;
                        double div = 1.0 / (sqdAB * sqdAC);
                        s.put(numerator * div, Math.sqrt(div));
                    }
                    pC.advance();
                }
            }
            pB.advance();
        }
        return s.getPopulationVariance();
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID KERNEL_FUNCTION_ID = new OptionID("abod.kernelfunction", "Kernel function to use.");
        protected Similarity<V> kernelFunction = null;

        public void configure(Parameterization config) {
            new ObjectParameter(KERNEL_FUNCTION_ID, Similarity.class, PolynomialKernel.class).grab(config, x -> {
                this.kernelFunction = x;
            });
        }

        public ABOD<V> make() {
            return new ABOD<V>(this.kernelFunction);
        }
    }
}

