/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.SetDBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.math.linearalgebra.CovarianceMatrix;
import elki.math.linearalgebra.LUDecomposition;
import elki.math.linearalgebra.VMath;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

@Title(value="Gaussian-Uniform Mixture Model Outlier Detection")
@Description(value="Fits a mixture model consisting of a Gaussian and a uniform distribution to the data.")
@Reference(prefix="Generalization using the likelihood gain as outlier score of", authors="E. Eskin", title="Anomaly detection over noisy data using learned probability distributions", booktitle="Proc. 17th Int. Conf. on Machine Learning (ICML-2000)", url="https://doi.org/10.7916/D8C53SKF", bibkey="DBLP:conf/icml/Eskin00")
public class GaussianUniformMixture
implements OutlierAlgorithm {
    private static final int MAX_ITER = 10;
    private double c;
    private double logl;
    private double logml;

    public GaussianUniformMixture(double l, double c) {
        this.logl = FastMath.log((double)l);
        this.logml = FastMath.log((double)(1.0 - l));
        this.c = c;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        ArrayDBIDs objids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        CovarianceMatrix builder = CovarianceMatrix.make(relation, (DBIDs)objids);
        HashSetModifiableDBIDs anomalous = DBIDUtil.newHashSet();
        WritableDoubleDataStore oscores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3);
        double logLike = (double)objids.size() * this.logml + this.loglikelihoodNormal((DBIDs)objids, (SetDBIDs)anomalous, builder, relation);
        DoubleMinMax minmax = new DoubleMinMax();
        for (int loop = 0; loop < 10; ++loop) {
            boolean changed = false;
            DBIDArrayIter iter = objids.iter();
            while (iter.valid()) {
                boolean wasadded = anomalous.add((DBIDRef)iter) || !anomalous.remove((DBIDRef)iter);
                NumberVector vec = (NumberVector)relation.get((DBIDRef)iter);
                builder.put(vec, wasadded ? -1.0 : 1.0);
                double currentLogLike = (double)(objids.size() - anomalous.size()) * this.logml + this.loglikelihoodNormal((DBIDs)objids, (SetDBIDs)anomalous, builder, relation) + (double)anomalous.size() * this.logl + this.loglikelihoodAnomalous((DBIDs)anomalous);
                double loglikeGain = currentLogLike - logLike;
                oscores.putDouble((DBIDRef)iter, loglikeGain);
                minmax.put(loglikeGain);
                if (loglikeGain > this.c) {
                    logLike = currentLogLike;
                    changed = true;
                } else {
                    wasadded = wasadded ? anomalous.remove((DBIDRef)iter) : !anomalous.add((DBIDRef)iter);
                    builder.put(vec, wasadded ? 1.0 : -1.0);
                }
                iter.advance();
            }
            assert ((long)anomalous.size() == Math.round((double)objids.size() - builder.getWeight()));
            if (!changed) break;
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        MaterializedDoubleRelation res = new MaterializedDoubleRelation("Gaussian Mixture Outlier Score", relation.getDBIDs(), (DoubleDataStore)oscores);
        return new OutlierResult(meta, (DoubleRelation)res);
    }

    private double loglikelihoodAnomalous(DBIDs anomalousObjs) {
        return anomalousObjs.isEmpty() ? 0.0 : (double)anomalousObjs.size() * -FastMath.log((double)anomalousObjs.size());
    }

    private double loglikelihoodNormal(DBIDs objids, SetDBIDs anomalous, CovarianceMatrix builder, Relation<? extends NumberVector> relation) {
        double[] mean = builder.getMeanVector();
        LUDecomposition lu = new LUDecomposition(builder.makeSampleMatrix());
        double[][] covInv = lu.inverse();
        double prob = (double)(objids.size() - anomalous.size()) * -FastMath.log((double)Math.sqrt(MathUtil.powi((double)(Math.PI * 2), (int)RelationUtil.dimensionality(relation)) * lu.det()));
        DBIDIter iter = objids.iter();
        while (iter.valid()) {
            if (!anomalous.contains((DBIDRef)iter)) {
                double[] xcent = VMath.minusEquals((double[])((NumberVector)relation.get((DBIDRef)iter)).toArray(), (double[])mean);
                prob -= 0.5 * VMath.transposeTimesTimes((double[])xcent, (double[][])covInv, (double[])xcent);
            }
            iter.advance();
        }
        return prob;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID L_ID = new OptionID("mmo.l", "expected fraction of outliers");
        public static final OptionID C_ID = new OptionID("mmo.c", "cutoff");
        protected double l = 1.0E-7;
        protected double c = 1.0E-7;

        public void configure(Parameterization config) {
            new DoubleParameter(L_ID, 1.0E-7).grab(config, x -> {
                this.l = x;
            });
            new DoubleParameter(C_ID, 1.0E-7).grab(config, x -> {
                this.c = x;
            });
        }

        public GaussianUniformMixture make() {
            return new GaussianUniformMixture(this.l, this.c);
        }
    }
}

