/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.scores.adapter;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.result.outlier.OutlierResult;

public class OutlierScoreAdapter
implements ScoreEvaluation.Adapter {
    private DBIDs set;
    private DBIDIter iter;
    private DoubleRelation scores;
    private double prev = Double.NaN;

    public OutlierScoreAdapter(DBIDs positive, OutlierResult o) {
        this.set = positive;
        this.iter = o.getOrdering().order(o.getScores().getDBIDs()).iter();
        this.scores = o.getScores();
    }

    public boolean valid() {
        return this.iter.valid();
    }

    public OutlierScoreAdapter advance() {
        this.prev = this.scores.doubleValue((DBIDRef)this.iter);
        this.iter.advance();
        return this;
    }

    public boolean tiedToPrevious() {
        return this.scores.doubleValue((DBIDRef)this.iter) == this.prev;
    }

    public boolean test() {
        return this.set.contains((DBIDRef)this.iter);
    }

    public int numPositive() {
        return this.set.size();
    }

    public int numTotal() {
        return this.scores.size();
    }
}

