/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.SetDBIDs;
import elki.database.relation.DoubleRelation;
import elki.evaluation.Evaluator;
import elki.evaluation.outlier.OutlierROCCurve;
import elki.logging.Logging;
import elki.math.geometry.XYCurve;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

@Reference(authors="W. Klement, P. A. Flach, N. Japkowicz, S. Matwin", title="Smooth Receiver Operating Characteristics (smROC) Curves", booktitle="European Conf. Machine Learning and Principles and Practice of Knowledge Discovery in Databases (ECML-PKDD'11)", url="https://doi.org/10.1007/978-3-642-23783-6_13", bibkey="DBLP:conf/pkdd/KlementFJM11")
public class OutlierSmROCCurve
implements Evaluator {
    public static final String SMAUROC_LABEL = "AUROC";
    private static final Logging LOG = Logging.getLogger(OutlierSmROCCurve.class);
    private Pattern positiveClassName;

    public OutlierSmROCCurve(Pattern positive_class_name) {
        this.positiveClassName = positive_class_name;
    }

    private SmROCResult computeSmROCResult(SetDBIDs positiveids, OutlierResult or) {
        DoubleRelation scores = or.getScores();
        int size = scores.size();
        double mean = 0.0;
        DBIDIter iditer = scores.iterDBIDs();
        while (iditer.valid()) {
            mean += scores.doubleValue((DBIDRef)iditer) / (double)size;
            iditer.advance();
        }
        SmROCResult curve = new SmROCResult(positiveids.size() + 2);
        curve.add(0.0, 0.0);
        int poscnt = 0;
        int negcnt = 0;
        double prevscore = Double.NaN;
        double x = 0.0;
        double y = 0.0;
        DBIDArrayMIter nei = or.getOrdering().order(or.getOrdering().getDBIDs()).iter();
        while (nei.valid()) {
            double curscore = scores.doubleValue((DBIDRef)nei);
            if (!Double.isNaN(prevscore) && Double.compare(prevscore, curscore) == 0) {
                if (positiveids.contains((DBIDRef)nei)) {
                    ++poscnt;
                } else {
                    ++negcnt;
                }
            } else {
                if (prevscore > mean) {
                    y += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
                    x += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
                } else if (prevscore < mean) {
                    y += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
                    x += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
                }
                curve.addAndSimplify(x, y);
                if (positiveids.contains((DBIDRef)nei)) {
                    poscnt = 1;
                    negcnt = 0;
                } else {
                    poscnt = 0;
                    negcnt = 1;
                }
                prevscore = curscore;
            }
            nei.advance();
        }
        if (prevscore > mean) {
            y += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
            x += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
        } else if (prevscore < mean) {
            y += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
            x += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
        }
        curve.addAndSimplify(x, y);
        double auroc = XYCurve.areaUnderCurve((XYCurve)curve) / (x * y);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("AUROC: " + auroc));
        }
        curve.auc = auroc;
        curve.setAxes(0.0, 0.0, 1.0, 1.0);
        return curve;
    }

    public void processNewResult(Object result) {
        Database db = ResultUtil.findDatabase((Object)result);
        SetDBIDs positiveids = DBIDUtil.ensureSet((DBIDs)DatabaseUtil.getObjectsByLabelMatch((Database)db, (Pattern)this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning((CharSequence)"Computing a ROC curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        for (OutlierResult o : oresults) {
            Metadata.hierarchyOf((Object)o).addChild((Object)this.computeSmROCResult(positiveids, o));
        }
    }

    public static class Par
    implements Parameterizer {
        protected Pattern positiveClassName = null;

        public void configure(Parameterization config) {
            new PatternParameter(OutlierROCCurve.Par.POSITIVE_CLASS_NAME_ID).grab(config, x -> {
                this.positiveClassName = x;
            });
        }

        public OutlierSmROCCurve make() {
            return new OutlierSmROCCurve(this.positiveClassName);
        }
    }

    public static class SmROCResult
    extends XYCurve {
        double auc = Double.NaN;

        public SmROCResult(int size) {
            super("SmROC Negative", "SmROC Positive", size);
            Metadata.of((Object)((Object)this)).setLongName("SmROC Curve");
        }

        public double getAUC() {
            return this.auc;
        }
    }
}

