/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.SetDBIDs;
import elki.evaluation.Evaluator;
import elki.evaluation.scores.ROCEvaluation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.evaluation.scores.adapter.OutlierScoreAdapter;
import elki.evaluation.scores.adapter.SimpleAdapter;
import elki.logging.Logging;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.OrderingResult;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierROCCurve
implements Evaluator {
    public static final String AUROC_LABEL = "AUROC";
    private static final Logging LOG = Logging.getLogger(OutlierROCCurve.class);
    private Pattern positiveClassName;

    public OutlierROCCurve(Pattern positive_class_name) {
        this.positiveClassName = positive_class_name;
    }

    public void processNewResult(Object result) {
        Database db = ResultUtil.findDatabase((Object)result);
        SetDBIDs positiveids = DBIDUtil.ensureSet((DBIDs)DatabaseUtil.getObjectsByLabelMatch((Database)db, (Pattern)this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning((CharSequence)"Computing a ROC curve failed - no objects matched.");
            return;
        }
        boolean nonefound = true;
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List orderings = ResultUtil.getOrderingResults((Object)result);
        for (OutlierResult o : oresults) {
            ROCEvaluation.ROCurve roc = ROCEvaluation.materializeROC((ScoreEvaluation.Adapter)new OutlierScoreAdapter((DBIDs)positiveids, o));
            Metadata.hierarchyOf((Object)o).addChild((Object)roc);
            EvaluationResult.MeasurementGroup g = EvaluationResult.findOrCreate((Object)o, (String)"Evaluation of Ranking").findOrCreateGroup("Evaluation measures");
            if (!g.hasMeasure(AUROC_LABEL)) {
                g.addMeasure(AUROC_LABEL, roc.getAUC(), 0.0, 1.0, false);
            }
            orderings.remove(o.getOrdering());
            nonefound = false;
        }
        for (OrderingResult or : orderings) {
            ArrayModifiableDBIDs sorted = or.order(or.getDBIDs());
            if (sorted.size() != or.getDBIDs().size()) {
                throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
            }
            ROCEvaluation.ROCurve roc = ROCEvaluation.materializeROC((ScoreEvaluation.Adapter)new SimpleAdapter((DBIDs)positiveids, sorted.iter(), sorted.size()));
            Metadata.hierarchyOf((Object)or).addChild((Object)roc);
            EvaluationResult.MeasurementGroup g = EvaluationResult.findOrCreate((Object)or, (String)"Evaluation of Ranking").findOrCreateGroup("Evaluation measures");
            if (!g.hasMeasure(AUROC_LABEL)) {
                g.addMeasure(AUROC_LABEL, roc.getAUC(), 0.0, 1.0, false);
            }
            nonefound = false;
        }
        if (nonefound) {
            // empty if block
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("auroc.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        public void configure(Parameterization config) {
            new PatternParameter(POSITIVE_CLASS_NAME_ID).grab(config, x -> {
                this.positiveClassName = x;
            });
        }

        public OutlierROCCurve make() {
            return new OutlierROCCurve(this.positiveClassName);
        }
    }
}

