/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.SetDBIDs;
import elki.evaluation.Evaluator;
import elki.evaluation.scores.PRGCEvaluation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.evaluation.scores.adapter.OutlierScoreAdapter;
import elki.evaluation.scores.adapter.SimpleAdapter;
import elki.logging.Logging;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.OrderingResult;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

@Reference(authors="P. Flach and M. Knull", title="Precision-Recall-Gain Curves: {PR} Analysis Done Right", booktitle="Neural Information Processing Systems (NIPS 2015)", url="http://papers.nips.cc/paper/5867-precision-recall-gain-curves-pr-analysis-done-right", bibkey="DBLP:conf/nips/FlachK15")
public class OutlierPrecisionRecallGainCurve
implements Evaluator {
    public static final String AUPRGC_LABEL = "AUPRGC";
    private static final Logging LOG = Logging.getLogger(OutlierPrecisionRecallGainCurve.class);
    private Pattern positiveClassName;

    public OutlierPrecisionRecallGainCurve(Pattern positiveClassName) {
        this.positiveClassName = positiveClassName;
    }

    public void processNewResult(Object newResult) {
        Database db = ResultUtil.findDatabase((Object)newResult);
        SetDBIDs positiveIDs = DBIDUtil.ensureSet((DBIDs)DatabaseUtil.getObjectsByLabelMatch((Database)db, (Pattern)this.positiveClassName));
        if (positiveIDs.size() == 0) {
            LOG.warning((CharSequence)"Computing a P/R-G curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> outResults = OutlierResult.getOutlierResults(newResult);
        List ordResults = ResultUtil.getOrderingResults((Object)newResult);
        for (OutlierResult o : outResults) {
            PRGCEvaluation.PRGCurve curve = PRGCEvaluation.materializePRGC((ScoreEvaluation.Adapter)new OutlierScoreAdapter((DBIDs)positiveIDs, o));
            Metadata.hierarchyOf((Object)o).addChild((Object)curve);
            EvaluationResult.MeasurementGroup g = EvaluationResult.findOrCreate((Object)o, (String)"Evaluation of Ranking").findOrCreateGroup("Evaluation measures");
            if (!g.hasMeasure(AUPRGC_LABEL)) {
                g.addMeasure(AUPRGC_LABEL, curve.getAUC(), 0.0, 1.0, false);
            }
            ordResults.remove(o.getOrdering());
        }
        for (OrderingResult r : ordResults) {
            ArrayModifiableDBIDs sorted = r.order(r.getDBIDs());
            PRGCEvaluation.PRGCurve curve = PRGCEvaluation.materializePRGC((ScoreEvaluation.Adapter)new SimpleAdapter((DBIDs)positiveIDs, sorted.iter(), sorted.size()));
            Metadata.hierarchyOf((Object)r).addChild((Object)curve);
            EvaluationResult.MeasurementGroup g = EvaluationResult.findOrCreate((Object)r, (String)"Evaluation of Ranking").findOrCreateGroup("Evaluation measures");
            if (g.hasMeasure(AUPRGC_LABEL)) continue;
            g.addMeasure(AUPRGC_LABEL, curve.getAUC(), 0.0, 1.0, false);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("precisionrecallgain.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        public void configure(Parameterization config) {
            new PatternParameter(POSITIVE_CLASS_NAME_ID).grab(config, x -> {
                this.positiveClassName = x;
            });
        }

        public OutlierPrecisionRecallGainCurve make() {
            return new OutlierPrecisionRecallGainCurve(this.positiveClassName);
        }
    }
}

