/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.SetDBIDs;
import elki.evaluation.Evaluator;
import elki.logging.Logging;
import elki.math.geometry.XYCurve;
import elki.result.Metadata;
import elki.result.OrderingResult;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierPrecisionAtKCurve
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(OutlierPrecisionAtKCurve.class);
    private Pattern positiveClassName;
    private int maxk = Integer.MAX_VALUE;

    public OutlierPrecisionAtKCurve(Pattern positiveClassName, int maxk) {
        this.positiveClassName = positiveClassName;
        this.maxk = maxk;
    }

    public void processNewResult(Object result) {
        ArrayModifiableDBIDs sorted;
        Database db = ResultUtil.findDatabase((Object)result);
        SetDBIDs positiveids = DBIDUtil.ensureSet((DBIDs)DatabaseUtil.getObjectsByLabelMatch((Database)db, (Pattern)this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning((CharSequence)"Computing a ROC curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List orderings = ResultUtil.getOrderingResults((Object)result);
        for (OutlierResult o : oresults) {
            sorted = o.getOrdering().order(o.getOrdering().getDBIDs());
            Metadata.hierarchyOf((Object)o).addChild((Object)this.computePrecisionResult(o.getScores().size(), positiveids, (DBIDs)sorted));
            orderings.remove(o.getOrdering());
        }
        for (OrderingResult or : orderings) {
            sorted = or.order(or.getDBIDs());
            Metadata.hierarchyOf((Object)or).addChild((Object)this.computePrecisionResult(or.getDBIDs().size(), positiveids, (DBIDs)sorted));
        }
    }

    private XYCurve computePrecisionResult(int size, SetDBIDs positiveids, DBIDs order) {
        if (order.size() != size) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        int lastk = Math.min(size, this.maxk);
        PrecisionAtKCurve curve = new PrecisionAtKCurve(lastk);
        int pos = 0;
        DBIDIter i = order.iter();
        for (int k = 1; k <= lastk; ++k) {
            if (positiveids.contains((DBIDRef)i)) {
                ++pos;
            }
            curve.addAndSimplify(k, (double)pos / (double)k);
            i.advance();
        }
        curve.setAxes(1.0, 0.0, lastk, 1.0);
        curve.setDrawingBounds(1.0, 0.0, lastk, 1.0);
        return curve;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("precision.positive", "Class label for the 'positive' class.");
        public static final OptionID MAX_K_ID = new OptionID("precision.maxk", "Maximum value of 'k' to compute the curve up to.");
        private Pattern positiveClassName;
        private int maxk = Integer.MAX_VALUE;

        public void configure(Parameterization config) {
            new PatternParameter(POSITIVE_CLASS_NAME_ID).grab(config, x -> {
                this.positiveClassName = x;
            });
            ((IntParameter)new IntParameter(MAX_K_ID).setOptional(true)).grab(config, x -> {
                this.maxk = x;
            });
        }

        public OutlierPrecisionAtKCurve make() {
            return new OutlierPrecisionAtKCurve(this.positiveClassName, this.maxk);
        }
    }

    public static class PrecisionAtKCurve
    extends XYCurve {
        public PrecisionAtKCurve(int size) {
            super("k", "Precision", size);
            Metadata.of((Object)((Object)this)).setLongName("Precision at k Curve");
        }
    }
}

