/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining.associationrules.interest;

import elki.itemsetmining.associationrules.interest.InterestingnessMeasure;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;

@References(value={@Reference(authors="A. Agresti", title="Categorical Data Analysis", booktitle="Categorical Data Analysis", bibkey="books/wiley/Agresti90"), @Reference(authors="P.-N. Tan, V. Kumar, J. Srivastava", title="Selecting the right objective measure for association analysis", booktitle="Information Systems 29.4", url="https://doi.org/10.1016/S0306-4379(03)00072-3", bibkey="DBLP:journals/is/TanKS04")})
public class PhiCorrelationCoefficient
implements InterestingnessMeasure {
    @Override
    public double measure(int t, int sX, int sY, int sXY) {
        double pXY = (double)sXY / (double)t;
        double pX = (double)sX / (double)t;
        double pY = (double)sY / (double)t;
        return (pXY - pX * pY) / Math.sqrt(pX * pY * (1.0 - pX) * (1.0 - pY));
    }
}

