/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining.associationrules.interest;

import elki.itemsetmining.associationrules.interest.InterestingnessMeasure;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;

@References(value={@Reference(authors="F. Mosteller", title="Association and Estimation in Contingency Tables", booktitle="Journal of the American Statistical Association 63:321", url="https://doi.org/10.1080/01621459.1968.11009219", bibkey="doi:10.1080/01621459.1968.11009219"), @Reference(authors="P.-N. Tan, V. Kumar, J. Srivastava", title="Selecting the right objective measure for association analysis", booktitle="Information Systems 29.4", url="https://doi.org/10.1016/S0306-4379(03)00072-3", bibkey="DBLP:journals/is/TanKS04")})
public class OddsRatio
implements InterestingnessMeasure {
    @Override
    public double measure(int t, int sX, int sY, int sXY) {
        double pXY = (double)sXY / (double)t;
        double pXnotY = (double)(sX - sXY) / (double)t;
        double pnotXY = (double)(sY - sXY) / (double)t;
        double pnotXnotY = 1.0 - (double)(sX + sY - sXY) / (double)t;
        return pXY * pnotXnotY / (pXnotY * pnotXY);
    }
}

