/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining.associationrules.interest;

import elki.itemsetmining.associationrules.interest.InterestingnessMeasure;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;
import net.jafama.FastMath;

@Reference(authors="R. M. Goodman, P. Smyth", title="Rule induction using information theory", booktitle="Knowledge Discovery in Databases 1991", bibkey="DBLP:books/mit/PF91/SmythG91")
public class JMeasure
implements InterestingnessMeasure {
    @Override
    public double measure(int t, int sX, int sY, int sXY) {
        double pXY = (double)sXY / (double)t;
        double pY_X = (double)sXY / (double)sX;
        double pY = (double)sY / (double)t;
        int sXnotY = sX - sXY;
        double pXnotY = (double)sXnotY / (double)t;
        double pnotY_X = (double)sXnotY / (double)sX;
        double pnotY = 1.0 - pY;
        return (pXY * FastMath.log((double)(pY_X / pY)) + pXnotY * FastMath.log((double)(pnotY_X / pnotY))) * MathUtil.ONE_BY_LOG2;
    }
}

