/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining.associationrules.interest;

import elki.itemsetmining.associationrules.interest.InterestingnessMeasure;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;

@References(value={@Reference(authors="P. Tan, V. Kumar", title="Interestingness measures for association patterns: A perspective", booktitle="Proc. Workshop on Postprocessing in Machine Learning and Data Mining", url="https://www.cs.umn.edu/sites/cs.umn.edu/files/tech_reports/00-036.pdf", bibkey="tr/umn/TanK00"), @Reference(authors="L. Breiman, J. H. Friedman, R. A. Olshen, C. J. Stone", title="Classification and Regression Trees", booktitle="", bibkey="books/wa/BreimanFOS84")})
public class GiniIndex
implements InterestingnessMeasure {
    @Override
    public double measure(int t, int sX, int sY, int sXY) {
        double pX = (double)sX / (double)t;
        double pY_X = (double)sXY / (double)sX;
        double pnotY_X = (double)(sX - sXY) / (double)sX;
        double pnotX = (double)(t - sX) / (double)t;
        double pY_notX = (double)(sY - sXY) / (double)(t - sX);
        double pnotY_notX = (double)(t - sX - (sY - sXY)) / (double)(t - sX);
        double pY = (double)sY / (double)t;
        double pnotY = (double)(t - sY) / (double)t;
        return pX * (pY_X * pY_X + pnotY_X * pnotY_X) + pnotX * (pY_notX * pY_notX + pnotY_notX * pnotY_notX) - pY * pY - pnotY * pnotY;
    }
}

