/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining.associationrules;

import elki.data.BitVector;
import elki.data.type.VectorFieldTypeInformation;
import elki.itemsetmining.Itemset;

public class AssociationRule
implements Comparable<AssociationRule> {
    private Itemset consequent;
    private Itemset antecedent;
    private Itemset union;
    private double measure;

    public AssociationRule(Itemset union, Itemset consequent, Itemset antecedent, double measure) {
        this.union = union;
        this.consequent = consequent;
        this.antecedent = antecedent;
        this.measure = measure;
    }

    public Itemset getConsequent() {
        return this.consequent;
    }

    public Itemset getUnion() {
        return this.union;
    }

    public double getMeasure() {
        return this.measure;
    }

    public Itemset getAntecedent() {
        return this.antecedent;
    }

    @Override
    public int compareTo(AssociationRule o) {
        return this.union.compareTo(o.union);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), null).toString();
    }

    public StringBuilder appendTo(StringBuilder buf, VectorFieldTypeInformation<BitVector> meta) {
        this.antecedent.appendTo(buf, meta);
        buf.append(" --> ");
        this.consequent.appendItemsTo(buf, meta);
        buf.append(": ");
        buf.append(this.union.getSupport());
        buf.append(" : ");
        buf.append(this.measure);
        return buf;
    }
}

