/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining;

import elki.data.BitVector;
import elki.data.SparseNumberVector;
import elki.data.type.VectorFieldTypeInformation;
import elki.itemsetmining.Itemset;
import elki.utilities.exceptions.APIViolationException;

public class OneItemset
extends Itemset {
    int item;

    public OneItemset(int item) {
        this.item = item;
    }

    public OneItemset(int item, int support) {
        this.item = item;
        this.support = support;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public boolean containedIn(SparseNumberVector bv) {
        return bv.doubleValue(this.item) != 0.0;
    }

    @Override
    public int iter() {
        return 0;
    }

    @Override
    public boolean iterValid(int iter) {
        return iter == 0;
    }

    @Override
    public int iterAdvance(int iter) {
        return 1;
    }

    @Override
    public int iterDim(int iter) {
        assert (iter == 0);
        return this.item;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof OneItemset && this.item == ((OneItemset)obj).item || super.equals(obj);
    }

    @Override
    @Deprecated
    public int hashCode() {
        throw new APIViolationException("Itemsets may not be used in hash maps.");
    }

    @Override
    public int compareTo(Itemset o) {
        if (o instanceof OneItemset) {
            int oitem = ((OneItemset)o).item;
            return this.item < oitem ? -1 : (this.item > oitem ? 1 : 0);
        }
        return super.compareTo(o);
    }

    @Override
    public StringBuilder appendItemsTo(StringBuilder buf, VectorFieldTypeInformation<BitVector> meta) {
        String lbl;
        String string = lbl = meta != null ? meta.getLabel(this.item) : null;
        if (lbl == null) {
            buf.append(this.item);
        } else {
            buf.append(lbl);
        }
        return buf;
    }
}

