/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining;

import elki.data.BitVector;
import elki.data.SparseFeatureVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.itemsetmining.AbstractFrequentItemsetAlgorithm;
import elki.itemsetmining.Itemset;
import elki.itemsetmining.OneItemset;
import elki.itemsetmining.SparseItemset;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.result.FrequentItemsetsResult;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Reference(authors="M. J. Zaki, S. Parthasarathy, M. Ogihara, W. Li", title="New Algorithms for Fast Discovery of Association Rules", booktitle="Proc. 3rd ACM SIGKDD '97 Int. Conf. on Knowledge Discovery and Data Mining", url="http://www.aaai.org/Library/KDD/1997/kdd97-060.php", bibkey="DBLP:conf/kdd/ZakiPOL97")
public class Eclat
extends AbstractFrequentItemsetAlgorithm {
    private static final Logging LOG = Logging.getLogger(Eclat.class);
    private static final String STAT = Eclat.class.getName() + ".";

    public Eclat(double minsupp, int minlength, int maxlength) {
        super(minsupp, minlength, maxlength);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.BIT_VECTOR_FIELD});
    }

    public FrequentItemsetsResult run(Relation<BitVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        VectorFieldTypeInformation meta = RelationUtil.assumeVectorField(relation);
        int minsupp = this.getMinimumSupport(relation.size());
        LOG.verbose((CharSequence)"Build 1-dimensional transaction lists.");
        Duration ctime = LOG.newDuration(STAT + "eclat.transposition.time").begin();
        DBIDs[] idx = this.buildIndex(relation, dim, minsupp);
        LOG.statistics((Statistic)ctime.end());
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Building frequent itemsets", idx.length, LOG) : null;
        Duration etime = LOG.newDuration(STAT + "eclat.extraction.time").begin();
        ArrayList<Itemset> solution = new ArrayList<Itemset>();
        for (int i = 0; i < idx.length; ++i) {
            LOG.incrementProcessed((AbstractProgress)prog);
            this.extractItemsets(idx, i, minsupp, solution);
        }
        LOG.ensureCompleted(prog);
        Collections.sort(solution);
        LOG.statistics((Statistic)etime.end());
        LOG.statistics((Statistic)new LongStatistic(STAT + "frequent-itemsets", (long)solution.size()));
        FrequentItemsetsResult result = new FrequentItemsetsResult(solution, (VectorFieldTypeInformation<BitVector>)meta, relation.size());
        Metadata.of((Object)result).setLongName("Eclat");
        return result;
    }

    private void extractItemsets(DBIDs[] idx, int start, int minsupp, List<Itemset> solution) {
        int[] buf = new int[idx.length];
        DBIDs iset = idx[start];
        if (iset == null || iset.size() < minsupp) {
            return;
        }
        if (this.minlength <= 1) {
            solution.add(new OneItemset(start, iset.size()));
        }
        if (this.maxlength > 1) {
            buf[0] = start;
            this.extractItemsets(iset, idx, buf, 1, start + 1, minsupp, solution);
        }
    }

    private void extractItemsets(DBIDs iset, DBIDs[] idx, int[] buf, int depth, int start, int minsupp, List<Itemset> solution) {
        int depth1 = depth + 1;
        for (int i = start; i < idx.length; ++i) {
            DBIDs ids;
            if (idx[i] == null || (ids = this.mergeJoin(iset, idx[i])).size() < minsupp) continue;
            buf[depth] = i;
            int[] items = Arrays.copyOf(buf, depth1);
            if (depth1 >= this.minlength) {
                solution.add(new SparseItemset(items, ids.size()));
            }
            if (depth1 > this.maxlength) continue;
            this.extractItemsets(ids, idx, buf, depth1, i + 1, minsupp, solution);
        }
    }

    private DBIDs mergeJoin(DBIDs first, DBIDs second) {
        assert (!(first instanceof HashSetDBIDs));
        assert (!(second instanceof HashSetDBIDs));
        ArrayModifiableDBIDs ids = DBIDUtil.newArray();
        DBIDIter i1 = first.iter();
        DBIDIter i2 = second.iter();
        while (i1.valid() && i2.valid()) {
            int c = DBIDUtil.compare((DBIDRef)i1, (DBIDRef)i2);
            if (c < 0) {
                i1.advance();
                continue;
            }
            if (c > 0) {
                i2.advance();
                continue;
            }
            ids.add((DBIDRef)i1);
            i1.advance();
            i2.advance();
        }
        return ids;
    }

    private DBIDs[] buildIndex(Relation<BitVector> relation, int dim, int minsupp) {
        ArrayModifiableDBIDs[] idx = new ArrayModifiableDBIDs[dim];
        for (int i = 0; i < dim; ++i) {
            idx[i] = DBIDUtil.newArray();
        }
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            SparseFeatureVector bv = (SparseFeatureVector)relation.get((DBIDRef)iter);
            int it = bv.iter();
            while (bv.iterValid(it)) {
                idx[bv.iterDim(it)].add((DBIDRef)iter);
                it = bv.iterAdvance(it);
            }
            iter.advance();
        }
        for (int i = 0; i < dim; ++i) {
            if (idx[i].size() < minsupp) {
                idx[i] = null;
                continue;
            }
            idx[i].sort();
        }
        return idx;
    }

    public static class Par
    extends AbstractFrequentItemsetAlgorithm.Par {
        public Eclat make() {
            return new Eclat(this.minsupp, this.minlength, this.maxlength);
        }
    }
}

