/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.application.GeneratorXMLSpec;
import elki.data.synthetic.bymodel.GeneratorMain;
import elki.data.synthetic.bymodel.GeneratorSingleCluster;
import elki.data.synthetic.bymodel.GeneratorStatic;
import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.math.statistics.distribution.Distribution;
import elki.math.statistics.distribution.GammaDistribution;
import elki.math.statistics.distribution.HaltonUniformDistribution;
import elki.math.statistics.distribution.NormalDistribution;
import elki.math.statistics.distribution.UniformDistribution;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FileUtil;
import elki.utilities.io.ParseUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import elki.utilities.xml.XMLNodeIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GeneratorXMLDatabaseConnection
extends AbstractDatabaseConnection {
    public static final String TAG_DATASET = "dataset";
    public static final String TAG_CLUSTER = "cluster";
    public static final String TAG_UNIFORM = "uniform";
    public static final String TAG_NORMAL = "normal";
    public static final String TAG_GAMMA = "gamma";
    public static final String TAG_HALTON = "halton";
    public static final String TAG_ROTATE = "rotate";
    public static final String TAG_TRANSLATE = "translate";
    public static final String TAG_CLIP = "clip";
    public static final String TAG_STATIC = "static";
    public static final String TAG_POINT = "point";
    public static final String ATTR_TEST = "test-model";
    public static final String ATTR_SEED = "random-seed";
    public static final String ATTR_DENSITY = "density-correction";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_MEAN = "mean";
    public static final String ATTR_STDDEV = "stddev";
    public static final String ATTR_K = "k";
    public static final String ATTR_THETA = "theta";
    public static final String ATTR_VECTOR = "vector";
    public static final String ATTR_AXIS1 = "axis1";
    public static final String ATTR_AXIS2 = "axis2";
    public static final String ATTR_ANGLE = "angle";
    private static final Logging LOG = Logging.getLogger(GeneratorXMLDatabaseConnection.class);
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    public static final String GENERATOR_SCHEMA_FILE = GeneratorXMLSpec.class.getPackage().getName().replace('.', '/') + '/' + "GeneratorByModel.xsd";
    URI specfile;
    double sizescale = 1.0;
    Pattern reassign = null;
    private RandomFactory clusterRandom = null;
    private Boolean testAgainstModel;
    private boolean reassignByDistance;

    public GeneratorXMLDatabaseConnection(List<? extends ObjectFilter> filters, URI specfile, double sizescale, Pattern reassign, boolean reassignByDistance, RandomFactory clusterRandom) {
        super(filters);
        this.specfile = specfile;
        this.sizescale = sizescale;
        this.reassign = reassign;
        this.reassignByDistance = reassignByDistance;
        this.clusterRandom = clusterRandom;
    }

    public MultipleObjectsBundle loadData() {
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Loading specification ...");
        }
        GeneratorMain gen = this.loadXMLSpecification();
        if (this.testAgainstModel != null) {
            gen.setTestAgainstModel(this.testAgainstModel);
        }
        gen.setReassignPattern(this.reassign);
        gen.setReassignByDistance(this.reassignByDistance);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Generating clusters ...");
        }
        return super.invokeBundleFilters(gen.generate());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GeneratorMain loadXMLSpecification() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            try (InputStream is = FileUtil.open((URI)this.specfile, (OpenOption[])new OpenOption[0]);){
                Document doc = dbf.newDocumentBuilder().parse(is);
                Element root = doc.getDocumentElement();
                if (!TAG_DATASET.equals(root.getNodeName())) throw new AbortException("Experiment specification has incorrect document element: " + root.getNodeName());
                GeneratorMain gen = new GeneratorMain();
                this.processElementDataset(gen, root);
                GeneratorMain generatorMain = gen;
                return generatorMain;
            }
        }
        catch (FileNotFoundException e) {
            throw new AbortException("Can't open specification file.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new AbortException("Error parsing specification file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AbortException("IO Exception loading specification file.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new AbortException("Parser Configuration Error", (Throwable)e);
        }
    }

    private void processElementDataset(GeneratorMain gen, Node cur) {
        String testmod;
        String seedstr = ((Element)cur).getAttribute(ATTR_SEED);
        if (this.clusterRandom != RandomFactory.DEFAULT && seedstr != null && seedstr.length() > 0) {
            this.clusterRandom = new RandomFactory((long)((double)ParseUtil.parseIntBase10((CharSequence)seedstr) * this.sizescale));
        }
        if ((testmod = ((Element)cur).getAttribute(ATTR_TEST)) != null && testmod.length() > 0) {
            this.testAgainstModel = ParseUtil.parseIntBase10((CharSequence)testmod) != 0;
        }
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (TAG_CLUSTER.equals(child.getNodeName())) {
                this.processElementCluster(gen, child);
                continue;
            }
            if (TAG_STATIC.equals(child.getNodeName())) {
                this.processElementStatic(gen, child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementCluster(GeneratorMain gen, Node cur) {
        int size = -1;
        double overweight = 1.0;
        String sizestr = ((Element)cur).getAttribute(ATTR_SIZE);
        if (sizestr != null && sizestr.length() > 0) {
            size = (int)((double)ParseUtil.parseIntBase10((CharSequence)sizestr) * this.sizescale);
        }
        String name = ((Element)cur).getAttribute(ATTR_NAME);
        String dcostr = ((Element)cur).getAttribute(ATTR_DENSITY);
        if (dcostr != null && dcostr.length() > 0) {
            overweight = ParseUtil.parseDouble((CharSequence)dcostr);
        }
        if (size < 0) {
            throw new AbortException("No valid cluster size given in specification file.");
        }
        if (name == null || name.length() == 0) {
            throw new AbortException("No cluster name given in specification file.");
        }
        Random newRand = this.clusterRandom.getSingleThreadedRandom();
        GeneratorSingleCluster cluster = new GeneratorSingleCluster(name, size, overweight, newRand);
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (TAG_UNIFORM.equals(child.getNodeName())) {
                this.processElementUniform(cluster, child);
                continue;
            }
            if (TAG_NORMAL.equals(child.getNodeName())) {
                this.processElementNormal(cluster, child);
                continue;
            }
            if (TAG_GAMMA.equals(child.getNodeName())) {
                this.processElementGamma(cluster, child);
                continue;
            }
            if (TAG_HALTON.equals(child.getNodeName())) {
                this.processElementHalton(cluster, child);
                continue;
            }
            if (TAG_ROTATE.equals(child.getNodeName())) {
                this.processElementRotate(cluster, child);
                continue;
            }
            if (TAG_TRANSLATE.equals(child.getNodeName())) {
                this.processElementTranslate(cluster, child);
                continue;
            }
            if (TAG_CLIP.equals(child.getNodeName())) {
                this.processElementClipping(cluster, child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
        gen.addCluster(cluster);
    }

    private void processElementUniform(GeneratorSingleCluster cluster, Node cur) {
        String maxstr;
        double min = 0.0;
        double max = 1.0;
        String minstr = ((Element)cur).getAttribute(ATTR_MIN);
        if (minstr != null && minstr.length() > 0) {
            min = ParseUtil.parseDouble((CharSequence)minstr);
        }
        if ((maxstr = ((Element)cur).getAttribute(ATTR_MAX)) != null && maxstr.length() > 0) {
            max = ParseUtil.parseDouble((CharSequence)maxstr);
        }
        cluster.addGenerator((Distribution)new UniformDistribution(min, max), cluster.getNewRandomGenerator());
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementNormal(GeneratorSingleCluster cluster, Node cur) {
        String stddevstr;
        double mean = 0.0;
        double stddev = 1.0;
        String meanstr = ((Element)cur).getAttribute(ATTR_MEAN);
        if (meanstr != null && meanstr.length() > 0) {
            mean = ParseUtil.parseDouble((CharSequence)meanstr);
        }
        if ((stddevstr = ((Element)cur).getAttribute(ATTR_STDDEV)) != null && stddevstr.length() > 0) {
            stddev = ParseUtil.parseDouble((CharSequence)stddevstr);
        }
        cluster.addGenerator((Distribution)new NormalDistribution(mean, stddev), cluster.getNewRandomGenerator());
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementGamma(GeneratorSingleCluster cluster, Node cur) {
        String thetastr;
        double k = 1.0;
        double theta = 1.0;
        String kstr = ((Element)cur).getAttribute(ATTR_K);
        if (kstr != null && kstr.length() > 0) {
            k = ParseUtil.parseDouble((CharSequence)kstr);
        }
        if ((thetastr = ((Element)cur).getAttribute(ATTR_THETA)) != null && thetastr.length() > 0) {
            theta = ParseUtil.parseDouble((CharSequence)thetastr);
        }
        cluster.addGenerator((Distribution)new GammaDistribution(k, theta), cluster.getNewRandomGenerator());
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementHalton(GeneratorSingleCluster cluster, Node cur) {
        String maxstr;
        double min = 0.0;
        double max = 1.0;
        String minstr = ((Element)cur).getAttribute(ATTR_MIN);
        if (minstr != null && minstr.length() > 0) {
            min = ParseUtil.parseDouble((CharSequence)minstr);
        }
        if ((maxstr = ((Element)cur).getAttribute(ATTR_MAX)) != null && maxstr.length() > 0) {
            max = ParseUtil.parseDouble((CharSequence)maxstr);
        }
        Random random = cluster.getNewRandomGenerator();
        HaltonUniformDistribution generator = new HaltonUniformDistribution(min, max, random);
        cluster.addGenerator((Distribution)generator, random);
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementRotate(GeneratorSingleCluster cluster, Node cur) {
        String anstr;
        String a2str;
        int axis1 = 0;
        int axis2 = 0;
        double angle = 0.0;
        String a1str = ((Element)cur).getAttribute(ATTR_AXIS1);
        if (a1str != null && a1str.length() > 0) {
            axis1 = ParseUtil.parseIntBase10((CharSequence)a1str);
        }
        if ((a2str = ((Element)cur).getAttribute(ATTR_AXIS2)) != null && a2str.length() > 0) {
            axis2 = ParseUtil.parseIntBase10((CharSequence)a2str);
        }
        if ((anstr = ((Element)cur).getAttribute(ATTR_ANGLE)) != null && anstr.length() > 0) {
            angle = ParseUtil.parseDouble((CharSequence)anstr);
        }
        if (axis1 <= 0 || axis1 > cluster.getDim()) {
            throw new AbortException("Invalid axis1 number given in specification file.");
        }
        if (axis2 <= 0 || axis2 > cluster.getDim()) {
            throw new AbortException("Invalid axis2 number given in specification file.");
        }
        if (axis1 == axis2) {
            throw new AbortException("Invalid axis numbers given in specification file.");
        }
        cluster.addRotation(axis1 - 1, axis2 - 1, Math.toRadians(angle));
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementTranslate(GeneratorSingleCluster cluster, Node cur) {
        double[] offset = null;
        String vstr = ((Element)cur).getAttribute(ATTR_VECTOR);
        if (vstr != null && vstr.length() > 0) {
            offset = this.parseVector(vstr);
        }
        if (offset == null) {
            throw new AbortException("No translation vector given.");
        }
        cluster.addTranslation(offset);
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementClipping(GeneratorSingleCluster cluster, Node cur) {
        String maxstr;
        double[] cmin = null;
        double[] cmax = null;
        String minstr = ((Element)cur).getAttribute(ATTR_MIN);
        if (minstr != null && minstr.length() > 0) {
            cmin = this.parseVector(minstr);
        }
        if ((maxstr = ((Element)cur).getAttribute(ATTR_MAX)) != null && maxstr.length() > 0) {
            cmax = this.parseVector(maxstr);
        }
        if (cmin == null || cmax == null) {
            throw new AbortException("No or incomplete clipping vectors given.");
        }
        cluster.setClipping(cmin, cmax);
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private void processElementStatic(GeneratorMain gen, Node cur) {
        String name = ((Element)cur).getAttribute(ATTR_NAME);
        if (name == null) {
            throw new AbortException("No cluster name given in specification file.");
        }
        ArrayList<double[]> points = new ArrayList<double[]>();
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (TAG_POINT.equals(child.getNodeName())) {
                this.processElementPoint(points, child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
        GeneratorStatic cluster = new GeneratorStatic(name, points);
        gen.addCluster(cluster);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Loaded cluster " + cluster.name + " from specification."));
        }
    }

    private void processElementPoint(List<double[]> points, Node cur) {
        double[] point = null;
        String vstr = ((Element)cur).getAttribute(ATTR_VECTOR);
        if (vstr != null && vstr.length() > 0) {
            point = this.parseVector(vstr);
        }
        if (point == null) {
            throw new AbortException("No translation vector given.");
        }
        points.add(point);
        XMLNodeIterator iter = new XMLNodeIterator(cur.getFirstChild());
        while (iter.hasNext()) {
            Node child = iter.next();
            if (child.getNodeType() != 1) continue;
            LOG.warning((CharSequence)("Unknown element in XML specification file: " + child.getNodeName()));
        }
    }

    private double[] parseVector(String s) {
        String[] entries = WHITESPACE_PATTERN.split(s);
        double[] d = new double[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            try {
                d[i] = ParseUtil.parseDouble((CharSequence)entries[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new AbortException("Could not parse vector.");
            }
        }
        return d;
    }

    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        public static final OptionID CONFIGFILE_ID = new OptionID("bymodel.spec", "The generator specification file.");
        public static final OptionID SIZE_SCALE_ID = new OptionID("bymodel.sizescale", "Factor for scaling the specified cluster sizes.");
        public static final OptionID REASSIGN_ID = new OptionID("bymodel.reassign", "Pattern to specify clusters to reassign.");
        public static final OptionID REASSIGN_DISTANCE_ID = new OptionID("bymodel.reassign-bydistance", "Reassign by distance, not by density.");
        public static final OptionID RANDOMSEED_ID = new OptionID("bymodel.randomseed", "The random generator seed.");
        URI specfile = null;
        double sizescale = 1.0;
        Pattern reassign = null;
        boolean reassignByDistance = false;
        RandomFactory clusterRandom;

        public void configure(Parameterization config) {
            super.configure(config);
            new FileParameter(CONFIGFILE_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                this.specfile = x;
            });
            new DoubleParameter(SIZE_SCALE_ID, 1.0).grab(config, x -> {
                this.sizescale = x;
            });
            ((PatternParameter)new PatternParameter(REASSIGN_ID).setOptional(true)).grab(config, x -> {
                this.reassign = x;
            });
            if (this.reassign != null) {
                new Flag(REASSIGN_DISTANCE_ID).grab(config, x -> {
                    this.reassignByDistance = x;
                });
            }
            new RandomParameter(RANDOMSEED_ID).grab(config, x -> {
                this.clusterRandom = x;
            });
            super.configFilters(config);
        }

        public GeneratorXMLDatabaseConnection make() {
            return new GeneratorXMLDatabaseConnection(this.filters, this.specfile, this.sizescale, this.reassign, this.reassignByDistance, this.clusterRandom);
        }
    }
}

