/*
 * Decompiled with CFR 0.152.
 */
package elki.data.synthetic.bymodel;

import elki.data.ClassLabel;
import elki.data.DoubleVector;
import elki.data.FeatureVector;
import elki.data.SimpleClassLabel;
import elki.data.model.Model;
import elki.data.synthetic.bymodel.GeneratorInterface;
import elki.data.synthetic.bymodel.GeneratorInterfaceDynamic;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class GeneratorMain {
    private static final Logging LOG = Logging.getLogger(GeneratorMain.class);
    protected ArrayList<GeneratorInterface> generators = new ArrayList();
    protected boolean testAgainstModel = true;
    protected Pattern relabelClusters = null;
    protected boolean relabelDistance = false;

    public void addCluster(GeneratorInterface c) {
        this.generators.add(c);
    }

    public MultipleObjectsBundle generate() {
        if (this.generators.isEmpty()) {
            throw new AbortException("No clusters specified.");
        }
        int dim = this.generators.get(0).getDim();
        for (GeneratorInterface c : this.generators) {
            if (c.getDim() == dim) continue;
            throw new AbortException("Cluster dimensions do not agree.");
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        VectorFieldTypeInformation type = new VectorFieldTypeInformation((FeatureVector.Factory)DoubleVector.FACTORY, dim);
        bundle.appendColumn((SimpleTypeInformation)type, new ArrayList());
        bundle.appendColumn(TypeUtil.CLASSLABEL, new ArrayList());
        bundle.appendColumn(Model.TYPE, new ArrayList());
        ClassLabel[] labels = new ClassLabel[this.generators.size()];
        Model[] models = new Model[this.generators.size()];
        this.initLabelsAndModels(this.generators, labels, models, this.relabelClusters);
        AssignPoint assignment = !this.testAgainstModel ? new AssignPoint() : (this.relabelClusters == null ? new TestModel() : (!this.relabelDistance ? new AssignLabelsByDensity(labels) : new AssignLabelsByDistance(labels)));
        for (int i = 0; i < labels.length; ++i) {
            GeneratorInterface curclus = this.generators.get(i);
            assignment.newCluster(i, curclus);
            GeneratorInterfaceDynamic cursclus = curclus instanceof GeneratorInterfaceDynamic ? (GeneratorInterfaceDynamic)curclus : null;
            int kept = 0;
            while (kept < curclus.getSize()) {
                List<double[]> newp = curclus.generate(curclus.getSize() - kept);
                for (double[] p : newp) {
                    int bestc = assignment.getAssignment(i, p);
                    if (bestc < 0 && cursclus != null) {
                        cursclus.incrementDiscarded();
                        continue;
                    }
                    bundle.appendSimple(new Object[]{DoubleVector.wrap((double[])p), labels[bestc], models[bestc]});
                    ++kept;
                }
            }
        }
        return bundle;
    }

    private void initLabelsAndModels(ArrayList<GeneratorInterface> generators, ClassLabel[] labels, Model[] models, Pattern reassign) {
        GeneratorInterface curclus;
        int i;
        int existingclusters = 0;
        if (reassign != null) {
            for (i = 0; i < labels.length; ++i) {
                curclus = generators.get(i);
                if (reassign.matcher(curclus.getName()).find()) continue;
                labels[i] = new SimpleClassLabel(curclus.getName());
                models[i] = curclus.makeModel();
                ++existingclusters;
            }
            if (existingclusters == 0) {
                LOG.warning((CharSequence)"All clusters matched the 'reassign' pattern. Ignoring.");
            }
            if (existingclusters == 1) {
                for (i = 0; i < labels.length; ++i) {
                    if (labels[i] == null) continue;
                    Arrays.fill(labels, labels[i]);
                    Arrays.fill(models, models[i]);
                    break;
                }
            }
            if (existingclusters == labels.length) {
                LOG.warning((CharSequence)"No clusters matched the 'reassign' pattern.");
            }
        }
        if (existingclusters == 0) {
            for (i = 0; i < labels.length; ++i) {
                curclus = generators.get(i);
                labels[i] = new SimpleClassLabel(curclus.getName());
                models[i] = curclus.makeModel();
            }
        }
    }

    public boolean isTestAgainstModel() {
        return this.testAgainstModel;
    }

    public void setTestAgainstModel(boolean testAgainstModel) {
        this.testAgainstModel = testAgainstModel;
    }

    public List<GeneratorInterface> getGenerators() {
        return Collections.unmodifiableList(this.generators);
    }

    public void setReassignPattern(Pattern reassign) {
        this.relabelClusters = reassign;
    }

    public void setReassignByDistance(boolean bydistance) {
        this.relabelDistance = bydistance;
    }

    private class AssignLabelsByDistance
    extends AssignPoint {
        private double[][] centers;

        public AssignLabelsByDistance(ClassLabel[] labels) {
            this.centers = this.clusterCenters(GeneratorMain.this.generators, labels);
        }

        private double[][] clusterCenters(ArrayList<GeneratorInterface> generators, ClassLabel[] labels) {
            int l = generators.size();
            double[][] vs = new double[l][];
            for (int i = 0; i < l; ++i) {
                if (labels[i] == null) continue;
                vs[i] = generators.get(i).computeMean();
            }
            return vs;
        }

        @Override
        public int getAssignment(int i, double[] p) {
            int bestc = i;
            boolean reassign = this.centers[i] == null;
            double is = reassign ? 0.0 : SquaredEuclideanDistance.STATIC.distance(this.centers[i], p);
            double bestd = reassign ? Double.POSITIVE_INFINITY : is;
            for (int j = 0; j < GeneratorMain.this.generators.size(); ++j) {
                double dist;
                if (this.centers[j] == null || !((dist = SquaredEuclideanDistance.STATIC.distance(this.centers[j], p)) < bestd)) continue;
                if (!reassign) {
                    return -1;
                }
                bestd = dist;
                bestc = j;
            }
            return bestc;
        }
    }

    private class AssignLabelsByDensity
    extends AssignPoint {
        private ClassLabel[] labels;
        private GeneratorInterface curclus;

        public AssignLabelsByDensity(ClassLabel[] labels) {
            this.labels = labels;
        }

        @Override
        public void newCluster(int i, GeneratorInterface curclus) {
            this.curclus = curclus;
        }

        @Override
        public int getAssignment(int i, double[] p) {
            double is = this.curclus.getDensity(p) * (double)this.curclus.getSize();
            int bestc = i;
            boolean reassign = this.labels[i] == null;
            double bestd = reassign ? Double.NEGATIVE_INFINITY : is;
            for (int j = 0; j < GeneratorMain.this.generators.size(); ++j) {
                if (j == i) continue;
                GeneratorInterface other = GeneratorMain.this.generators.get(j);
                double dens = other.getDensity(p) * (double)other.getSize();
                if (dens > is) {
                    return -1;
                }
                if (!reassign || this.labels[j] == null || !(dens > bestd)) continue;
                bestd = dens;
                bestc = j;
            }
            return bestc;
        }
    }

    private class TestModel
    extends AssignPoint {
        private TestModel() {
        }

        @Override
        public int getAssignment(int i, double[] p) {
            int bestc = i;
            GeneratorInterface curclus = GeneratorMain.this.generators.get(i);
            double is = curclus.getDensity(p) * (double)curclus.getSize();
            for (int j = 0; j < GeneratorMain.this.generators.size(); ++j) {
                GeneratorInterface other;
                double dens;
                if (j == i || !((dens = (other = GeneratorMain.this.generators.get(j)).getDensity(p) * (double)other.getSize()) > is)) continue;
                return -1;
            }
            return bestc;
        }
    }

    private static class AssignPoint {
        private AssignPoint() {
        }

        public int getAssignment(int i, double[] p) {
            return i;
        }

        public void newCluster(int i, GeneratorInterface curclus) {
        }
    }
}

