/*
 * Decompiled with CFR 0.152.
 */
package elki.application;

import elki.application.AbstractApplication;
import elki.data.model.Model;
import elki.data.synthetic.bymodel.GeneratorSingleCluster;
import elki.data.type.TypeInformation;
import elki.datasource.GeneratorXMLDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.logging.Logging;
import elki.math.statistics.distribution.Distribution;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.parameterization.Parameterization;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GeneratorXMLSpec
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(GeneratorXMLSpec.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Path outputFile;
    private GeneratorXMLDatabaseConnection generator;

    public GeneratorXMLSpec(Path output, GeneratorXMLDatabaseConnection generator) {
        this.outputFile = output;
        this.generator = generator;
    }

    public void run() {
        MultipleObjectsBundle data = this.generator.loadData();
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Writing output ...");
        }
        try {
            if (Files.exists(this.outputFile, new LinkOption[0]) && LOG.isVerbose()) {
                LOG.verbose((CharSequence)("The file " + this.outputFile + " already exists, the generator result will be OVERWRITTEN."));
            }
            try (BufferedWriter outStream = Files.newBufferedWriter(this.outputFile, StandardOpenOption.CREATE);){
                this.writeClusters(outStream, data);
            }
        }
        catch (IOException e) {
            throw new AbortException("IO Error in data generator.", (Throwable)e);
        }
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Done.");
        }
    }

    public void writeClusters(BufferedWriter outStream, MultipleObjectsBundle data) throws IOException {
        int modelcol = -1;
        for (int i = 0; i < data.metaLength(); ++i) {
            if (!Model.TYPE.isAssignableFromType((TypeInformation)data.meta(i))) continue;
            modelcol = i;
            break;
        }
        if (modelcol < 0) {
            throw new AbortException("No model column found in bundle.");
        }
        ArrayList<Model> models = new ArrayList<Model>();
        HashMap<Model, IntArrayList> modelMap = new HashMap<Model, IntArrayList>();
        for (int i = 0; i < data.dataLength(); ++i) {
            Model model = (Model)data.data(i, modelcol);
            IntArrayList modelids = (IntArrayList)modelMap.get(model);
            if (modelids == null) {
                models.add(model);
                modelids = new IntArrayList();
                modelMap.put(model, modelids);
            }
            modelids.add(i);
        }
        int totalsize = 0;
        int totaldisc = 0;
        for (Map.Entry entry : modelMap.entrySet()) {
            totalsize += ((IntArrayList)entry.getValue()).size();
            if (!(entry.getKey() instanceof GeneratorSingleCluster)) continue;
            totaldisc += ((GeneratorSingleCluster)entry.getKey()).getDiscarded();
        }
        double globdens = (double)(totalsize + totaldisc) / (double)totalsize;
        outStream.append("########################################################").append(LINE_SEPARATOR);
        outStream.append("## Number of clusters: " + models.size()).append(LINE_SEPARATOR);
        for (Model model : models) {
            IntArrayList ids = (IntArrayList)modelMap.get(model);
            outStream.append("########################################################").append(LINE_SEPARATOR);
            outStream.append("## Size: " + ids.size()).append(LINE_SEPARATOR);
            if (model instanceof GeneratorSingleCluster) {
                GeneratorSingleCluster cursclus = (GeneratorSingleCluster)model;
                outStream.append("########################################################").append(LINE_SEPARATOR);
                outStream.append("## Cluster: ").append(cursclus.getName()).append(LINE_SEPARATOR);
                double[] cmin = cursclus.getClipmin();
                double[] cmax = cursclus.getClipmax();
                if (cmin != null && cmax != null) {
                    outStream.append("## Clipping: ").append(FormatUtil.format((double[])cmin)).append(" - ").append(FormatUtil.format((double[])cmax)).append(LINE_SEPARATOR);
                }
                outStream.append("## Density correction factor: " + cursclus.getDensityCorrection()).append(LINE_SEPARATOR);
                outStream.append("## Generators:").append(LINE_SEPARATOR);
                for (int i = 0; i < cursclus.getDim(); ++i) {
                    Distribution gen = cursclus.getDistribution(i);
                    outStream.append("##   ").append(gen.toString()).append(LINE_SEPARATOR);
                }
                if (cursclus.getTransformation() != null && cursclus.getTransformation().getTransformation() != null) {
                    outStream.append("## Affine transformation matrix:").append(LINE_SEPARATOR);
                    outStream.append(FormatUtil.format((double[][])cursclus.getTransformation().getTransformation(), (String)"## ")).append(LINE_SEPARATOR);
                }
                outStream.append("## Discards: " + cursclus.getDiscarded() + " Retries left: " + cursclus.getRetries()).append(LINE_SEPARATOR);
                double corf = (double)(cursclus.getSize() + cursclus.getDiscarded()) / (double)cursclus.getSize() / globdens;
                outStream.append("## Density correction factor estimation: " + corf).append(LINE_SEPARATOR);
            }
            outStream.append("########################################################").append(LINE_SEPARATOR);
            IntListIterator iter = ids.iterator();
            while (iter.hasNext()) {
                int num = iter.nextInt();
                for (int c = 0; c < data.metaLength(); ++c) {
                    if (c == modelcol) continue;
                    if (c > 0) {
                        outStream.append(' ');
                    }
                    outStream.append(data.data(num, c).toString());
                }
                outStream.append(LINE_SEPARATOR);
            }
        }
    }

    public static void main(String[] args) {
        GeneratorXMLSpec.runCLIApplication(GeneratorXMLSpec.class, (String[])args);
    }

    public static class Par
    extends AbstractApplication.Par {
        private Path outputFile = null;
        private GeneratorXMLDatabaseConnection generator = null;

        public void configure(Parameterization config) {
            super.configure(config);
            this.generator = (GeneratorXMLDatabaseConnection)((Object)config.tryInstantiate(GeneratorXMLDatabaseConnection.class));
            this.outputFile = this.getParameterOutputFile(config, "The file to write the generated data set into, if the file already exists, the generated points will be appended to this file.");
        }

        public GeneratorXMLSpec make() {
            return new GeneratorXMLSpec(this.outputFile, this.generator);
        }
    }
}

