/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public class HttpURLConnectionUtils {
    public static HttpURLConnection connect(String urlSpec) throws IOException {
        return HttpURLConnectionUtils.connect(urlSpec, null, null);
    }

    public static HttpURLConnection connect(String urlSpec, String user, String password) throws IOException {
        if (!StringUtils.startsWith((CharSequence)urlSpec, (CharSequence)"http")) {
            throw new IllegalArgumentException("Illegal url: " + urlSpec);
        }
        URL url = new URL(urlSpec);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setUseCaches(false);
        boolean isHttps = StringUtils.startsWith((CharSequence)urlSpec, (CharSequence)"https");
        if (isHttps) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            httpsURLConnection.setSSLSocketFactory(HttpURLConnectionUtils.trustAllSslSocketFactory());
            httpsURLConnection.setHostnameVerifier(new TrustAllHostname());
        }
        if (user != null) {
            if (password == null) {
                password = "";
            }
            String credential = user + ":" + password;
            String auth = "Basic " + Base64.getEncoder().encodeToString(credential.getBytes());
            httpURLConnection.setRequestProperty("Authorization", auth);
        }
        return httpURLConnection;
    }

    public static SSLSocketFactory trustAllSslSocketFactory() {
        try {
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustAllManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, trustManagers, SecureRandom.getInstance("SHA1PRNG"));
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TrustAllHostname
    implements HostnameVerifier {
        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    public static class X509TrustAllManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

