/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.latex;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.ddr.poi.math.MathMLUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.DefaultTransformerFactoryChooser;
import uk.ac.ed.ph.snuggletex.utilities.TransformerFactoryChooser;

public class LaTeXUtils {
    private static final Logger log = LoggerFactory.getLogger(LaTeXUtils.class);

    public static SnuggleSession createSession() {
        return Initializer.SNUGGLE_ENGINE.createSession();
    }

    public static boolean parse(SnuggleSession session, String data) {
        SnuggleInput input = new SnuggleInput(data);
        boolean valid = false;
        try {
            valid = session.parseInput(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (CollectionUtils.isNotEmpty((Collection)session.getErrors())) {
            log.warn("Invalid LaTex: {}", (Object)data);
            for (InputError error : session.getErrors()) {
                log.warn("LaTeX parse error: {}", (Object)error);
            }
        }
        return valid;
    }

    public static void renderTo(XWPFParagraph paragraph, CTR ctr, SnuggleSession session) {
        NodeList nodeList = session.buildDOMSubtree();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Text) {
                ctr = paragraph.getCTP().addNewR();
                ctr.addNewT().setStringValue(node.getTextContent());
                continue;
            }
            if (!"math".equals(node.getLocalName())) continue;
            String math = XMLUtilities.serializeNode((Node)node, (SerializationSpecifier)Initializer.SNUGGLE_ENGINE.getDefaultXMLStringOutputOptions());
            MathMLUtils.renderTo(paragraph, ctr, math);
        }
    }

    private static class Initializer {
        static final SnuggleEngine SNUGGLE_ENGINE = new SnuggleEngine((TransformerFactoryChooser)DefaultTransformerFactoryChooser.getInstance(), null);

        private Initializer() {
        }

        static {
            CorePackageDefinitions.getPackage().loadMathCharacterAliases("math-character-aliases.txt");
        }
    }
}

