/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.math;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTOMath;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathMLUtils {
    private static final Logger log = LoggerFactory.getLogger(MathMLUtils.class);
    private static final String MATH_FONT = "Cambria Math";

    public static void renderTo(XWPFParagraph paragraph, String math) {
        if (log.isDebugEnabled()) {
            log.info("Start rendering MathML: {}", (Object)math);
        }
        try (StringReader sr = new StringReader(math);
             StringWriter sw = new StringWriter();){
            Serializer out = MathMLUtils.newSerializer(sw);
            Initializer.TRANSFORMER.transform((Source)new StreamSource(sr), (Destination)out);
            String omath = sw.toString();
            if (log.isDebugEnabled()) {
                log.info("Output OMath: {}", (Object)omath);
            }
            MathMLUtils.addMath(paragraph, omath);
        }
        catch (IOException | SaxonApiException | XmlException e) {
            log.warn("Failed to render math: {}", (Object)math, (Object)e);
        }
    }

    private static Serializer newSerializer(StringWriter sw) {
        Serializer out = Initializer.PROCESSOR.newSerializer((Writer)sw);
        out.setOutputProperty(Serializer.Property.METHOD, "xml");
        out.setOutputProperty(Serializer.Property.INDENT, "no");
        out.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        return out;
    }

    private static void addMath(XWPFParagraph paragraph, String omath) throws XmlException {
        CTOMath ctoMath = CTOMath.Factory.parse((String)omath);
        XmlCursor xmlCursor = ctoMath.newCursor();
        while (xmlCursor.hasNextToken()) {
            XmlCursor.TokenType tokenType = xmlCursor.toNextToken();
            if (tokenType != XmlCursor.TokenType.START || !(xmlCursor.getObject() instanceof CTR)) continue;
            CTFonts ctFonts = ((CTR)xmlCursor.getObject()).addNewRPr2().addNewRFonts();
            ctFonts.setAscii(MATH_FONT);
            ctFonts.setEastAsia(MATH_FONT);
            ctFonts.setHAnsi(MATH_FONT);
            ctFonts.setCs(MATH_FONT);
        }
        xmlCursor.dispose();
        CTP ctp = paragraph.getCTP();
        ctp.addNewOMath();
        ctp.setOMathArray(ctp.sizeOfOMathArray() - 1, ctoMath.getOMathArray(0));
    }

    private static class Initializer {
        static final Processor PROCESSOR = new Processor(false);
        static final Xslt30Transformer TRANSFORMER = Initializer.createTransformer();

        private Initializer() {
        }

        private static Xslt30Transformer createTransformer() {
            XsltExecutable stylesheet;
            XsltCompiler compiler = PROCESSOR.newXsltCompiler();
            try (InputStream inputStream = MathMLUtils.class.getResourceAsStream("/MML2OMML.XSL");){
                stylesheet = compiler.compile((Source)new StreamSource(inputStream));
            }
            catch (IOException | SaxonApiException e) {
                throw new IllegalStateException("Failed to load MML2OMML.XSL", e);
            }
            return stylesheet.load30();
        }
    }
}

