/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.RenderUtils;
import org.jsoup.nodes.Element;

public class TableCellRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"th", "td"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        CSSStyleDeclarationImpl styleDeclaration = context.currentElementStyle();
        int row = NumberUtils.toInt((String)element.attr("_r"));
        int column = NumberUtils.toInt((String)element.attr("_c"));
        XWPFTable table = context.getClosestTable();
        XWPFTableCell cell = table.getRow(row).getCell(column);
        context.pushContainer((IBody)cell);
        context.pushClosestBody((IBodyElement)cell.getParagraphArray(0));
        RenderUtils.cellStyle(context, cell, styleDeclaration);
        return true;
    }

    @Override
    public void renderEnd(Element element, HtmlRenderContext context) {
        context.popContainer();
        context.popClosestBody();
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }
}

