/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html;

import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.Property;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlConstants;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.tag.ARenderer;
import org.ddr.poi.html.tag.BigRenderer;
import org.ddr.poi.html.tag.BoldRenderer;
import org.ddr.poi.html.tag.BreakRenderer;
import org.ddr.poi.html.tag.DeleteRenderer;
import org.ddr.poi.html.tag.HeaderBreakRenderer;
import org.ddr.poi.html.tag.HeaderRenderer;
import org.ddr.poi.html.tag.ImageRenderer;
import org.ddr.poi.html.tag.ItalicRenderer;
import org.ddr.poi.html.tag.ListItemRenderer;
import org.ddr.poi.html.tag.ListRenderer;
import org.ddr.poi.html.tag.MathRenderer;
import org.ddr.poi.html.tag.OmittedRenderer;
import org.ddr.poi.html.tag.SmallRenderer;
import org.ddr.poi.html.tag.SubscriptRenderer;
import org.ddr.poi.html.tag.SuperscriptRenderer;
import org.ddr.poi.html.tag.TableCellRenderer;
import org.ddr.poi.html.tag.TableRenderer;
import org.ddr.poi.html.tag.UnderlineRenderer;
import org.ddr.poi.html.tag.WalkThroughRenderer;
import org.ddr.poi.html.util.BoxProperty;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.Colors;
import org.ddr.poi.html.util.NamedBorderWidth;
import org.ddr.poi.html.util.RenderUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSValue;

public class HtmlRenderPolicy
extends AbstractRenderPolicy<String> {
    private static final Logger log = LoggerFactory.getLogger(HtmlRenderPolicy.class);
    private final Map<String, ElementRenderer> elRenderers;
    private static final Pattern FORMATTED_PATTERN = Pattern.compile(">\\s+<");
    private static final String FORMATTED_REPLACEMENT = "><";
    private final String globalFont;
    private final int globalFontSizeInHalfPoints;

    public HtmlRenderPolicy() {
        this(null, null);
    }

    public HtmlRenderPolicy(String globalFont, CSSLength globalFontSize) {
        ElementRenderer[] renderers = new ElementRenderer[]{new ARenderer(), new BigRenderer(), new BoldRenderer(), new BreakRenderer(), new DeleteRenderer(), new HeaderBreakRenderer(), new HeaderRenderer(), new ImageRenderer(), new ItalicRenderer(), new ListItemRenderer(), new ListRenderer(), new MathRenderer(), new OmittedRenderer(), new SmallRenderer(), new SubscriptRenderer(), new SuperscriptRenderer(), new TableCellRenderer(), new TableRenderer(), new UnderlineRenderer(), new WalkThroughRenderer()};
        this.elRenderers = new HashMap<String, ElementRenderer>(renderers.length);
        for (ElementRenderer renderer : renderers) {
            for (String tag : renderer.supportedTags()) {
                this.elRenderers.put(tag, renderer);
            }
        }
        this.globalFont = globalFont;
        this.globalFontSizeInHalfPoints = globalFontSize == null ? 0 : globalFontSize.toHalfPoints();
    }

    protected boolean validate(String data) {
        return StringUtils.isNotEmpty((CharSequence)data);
    }

    public void doRender(RenderContext<String> context) throws Exception {
        String html = FORMATTED_PATTERN.matcher((CharSequence)context.getData()).replaceAll(FORMATTED_REPLACEMENT);
        Document document = Jsoup.parseBodyFragment((String)html);
        HtmlRenderContext htmlRenderContext = new HtmlRenderContext(context);
        htmlRenderContext.setGlobalFont(this.globalFont);
        if (this.globalFontSizeInHalfPoints > 0) {
            htmlRenderContext.setGlobalFontSize(BigInteger.valueOf(this.globalFontSizeInHalfPoints));
        }
        for (Node node : document.body().childNodes()) {
            this.renderNode(node, htmlRenderContext);
        }
    }

    private void renderNode(Node node, HtmlRenderContext context) {
        boolean isElement = node instanceof Element;
        if (isElement) {
            Element element = (Element)node;
            this.renderElement(element, context);
        } else if (node instanceof TextNode) {
            context.renderText(((TextNode)node).text());
        }
    }

    private void renderElement(Element element, HtmlRenderContext context) {
        if (log.isDebugEnabled()) {
            log.info("Start rendering html tag: <{}{}>", (Object)element.normalName(), (Object)element.attributes());
        }
        if (element.tag().isFormListed()) {
            return;
        }
        CSSStyleDeclarationImpl cssStyleDeclaration = this.getCssStyleDeclaration(element);
        String display = cssStyleDeclaration.getPropertyValue("display");
        if ("none".equalsIgnoreCase(display)) {
            return;
        }
        context.pushInlineStyle(cssStyleDeclaration, element.isBlock());
        ElementRenderer elementRenderer = this.elRenderers.get(element.normalName());
        if (element.isBlock() && (elementRenderer == null || elementRenderer.renderAsBlock())) {
            XmlCursor xmlCursor;
            IBodyElement closestBody = context.getClosestBody();
            switch (closestBody.getElementType()) {
                case PARAGRAPH: {
                    xmlCursor = ((XWPFParagraph)closestBody).getCTP().newCursor();
                    break;
                }
                case TABLE: {
                    xmlCursor = ((XWPFTable)closestBody).getCTTbl().newCursor();
                    break;
                }
                default: {
                    return;
                }
            }
            IBody container = context.getContainer();
            boolean isTableTag = "table".equals(element.normalName());
            if (isTableTag && xmlCursor.toPrevSibling()) {
                if (xmlCursor.getObject() instanceof CTTbl) {
                    xmlCursor.toEndToken();
                    xmlCursor.toNextToken();
                    container.insertNewParagraph(xmlCursor);
                }
                xmlCursor.toNextSibling();
            }
            xmlCursor.toEndToken();
            xmlCursor.toNextToken();
            if (isTableTag) {
                XWPFTable xwpfTable = container.insertNewTbl(xmlCursor);
                xmlCursor.dispose();
                xwpfTable.removeRow(0);
                context.replaceClosestBody((IBodyElement)xwpfTable);
                RenderUtils.tableStyle(context, xwpfTable, cssStyleDeclaration);
            } else {
                XWPFParagraph xwpfParagraph = container.insertNewParagraph(xmlCursor);
                xmlCursor.dispose();
                if (xwpfParagraph == null) {
                    log.warn("Can not add new paragraph for element: {}, attributes: {}", (Object)element.tagName(), (Object)element.attributes().html());
                }
                context.replaceClosestBody((IBodyElement)xwpfParagraph);
                RenderUtils.paragraphStyle(context, xwpfParagraph, cssStyleDeclaration);
            }
        }
        if (elementRenderer != null && !elementRenderer.renderStart(element, context)) {
            elementRenderer.renderEnd(element, context);
            context.popInlineStyle();
            return;
        }
        for (Node child : element.childNodes()) {
            this.renderNode(child, context);
        }
        if (elementRenderer != null) {
            elementRenderer.renderEnd(element, context);
        }
        context.popInlineStyle();
    }

    protected void afterRender(RenderContext<String> context) {
        List bodyElements;
        this.clearPlaceholder(context, true);
        IBody container = context.getContainer();
        if (container.getPartType() == BodyType.TABLECELL && ((bodyElements = container.getBodyElements()).isEmpty() || ((IBodyElement)bodyElements.get(bodyElements.size() - 1)).getElementType() != BodyElementType.PARAGRAPH)) {
            ((XWPFTableCell)container).addParagraph();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CSSStyleDeclarationImpl getCssStyleDeclaration(Element element) {
        String style = element.attr("style");
        try (StringReader sr = new StringReader(style);){
            CSSStyleDeclarationImpl cssStyleDeclaration = (CSSStyleDeclarationImpl)RenderUtils.CSS_PARSER.parseStyleDeclaration(new InputSource((Reader)sr));
            block39: for (int i = cssStyleDeclaration.getProperties().size() - 1; i >= 0; --i) {
                Property p = (Property)cssStyleDeclaration.getProperties().get(i);
                if (p == null || p.getValue() == null) continue;
                String name = p.getName().toLowerCase();
                CSSValueImpl valueList = (CSSValueImpl)p.getValue();
                int length = valueList.getLength();
                switch (name) {
                    case "background": {
                        this.splitBackground(valueList, length, cssStyleDeclaration, i);
                        continue block39;
                    }
                    case "border": {
                        this.splitBorder(valueList, length, cssStyleDeclaration, i);
                        continue block39;
                    }
                    case "border-top": {
                        this.splitBorder(valueList, length, cssStyleDeclaration, i, "border-top-style", "border-top-width", "border-top-color");
                        continue block39;
                    }
                    case "border-right": {
                        this.splitBorder(valueList, length, cssStyleDeclaration, i, "border-right-style", "border-right-width", "border-right-color");
                        continue block39;
                    }
                    case "border-bottom": {
                        this.splitBorder(valueList, length, cssStyleDeclaration, i, "border-bottom-style", "border-bottom-width", "border-bottom-color");
                        continue block39;
                    }
                    case "border-left": {
                        this.splitBorder(valueList, length, cssStyleDeclaration, i, "border-left-style", "border-left-width", "border-left-color");
                        continue block39;
                    }
                    case "border-style": {
                        this.splitBox(valueList, length, cssStyleDeclaration, i, BoxProperty.BORDER_STYLE);
                        continue block39;
                    }
                    case "border-width": {
                        this.splitBox(valueList, length, cssStyleDeclaration, i, BoxProperty.BORDER_WIDTH);
                        continue block39;
                    }
                    case "border-color": {
                        this.splitBox(valueList, length, cssStyleDeclaration, i, BoxProperty.BORDER_COLOR);
                        continue block39;
                    }
                    case "font": {
                        this.splitFont(valueList, length, cssStyleDeclaration, i);
                        continue block39;
                    }
                    case "margin": {
                        this.splitBox(valueList, length, cssStyleDeclaration, i, BoxProperty.MARGIN);
                        continue block39;
                    }
                    case "padding": {
                        this.splitBox(valueList, length, cssStyleDeclaration, i, BoxProperty.PADDING);
                        continue block39;
                    }
                }
            }
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = cssStyleDeclaration;
            return cSSStyleDeclarationImpl;
        }
        catch (IOException e) {
            log.warn("Inline style parse error: {}", (Object)style, (Object)e);
            return RenderUtils.EMPTY_STYLE;
        }
    }

    private void splitBackground(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl cssStyleDeclaration, int i) {
        block2: {
            block1: {
                if (length != 0) break block1;
                String cssText = valueList.getCssText().toLowerCase();
                String color = Colors.fromStyle(cssText, null);
                if (color == null) break block2;
                cssStyleDeclaration.getProperties().add(i, new Property("background-color", (CSSValue)valueList, false));
                break block2;
            }
            for (int j = 0; j < length; ++j) {
                CSSValue item = valueList.item(j);
                String cssText = item.getCssText().toLowerCase();
                String color = Colors.fromStyle(cssText, null);
                if (color == null) continue;
                cssStyleDeclaration.getProperties().add(i, new Property("background-color", item, false));
                break;
            }
        }
    }

    private void splitBorder(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl cssStyleDeclaration, int i) {
        if (length == 0) {
            String cssText = valueList.getCssText();
            if (StringUtils.isNotBlank((CharSequence)cssText)) {
                this.handleBorderValue(cssStyleDeclaration, i, (CSSValue)valueList, cssText);
            }
        } else {
            for (int j = 0; j < length; ++j) {
                CSSValue item = valueList.item(j);
                String value = item.getCssText();
                this.handleBorderValue(cssStyleDeclaration, i, item, value);
            }
        }
    }

    private void splitBorder(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl cssStyleDeclaration, int i, String styleProperty, String widthProperty, String colorProperty) {
        if (length == 0) {
            String cssText = valueList.getCssText();
            if (StringUtils.isNotBlank((CharSequence)cssText)) {
                this.handleBorderValue(cssStyleDeclaration, i, (CSSValue)valueList, cssText, styleProperty, widthProperty, colorProperty);
            }
        } else {
            for (int j = 0; j < length; ++j) {
                CSSValue item = valueList.item(j);
                String value = item.getCssText();
                this.handleBorderValue(cssStyleDeclaration, i, item, value, styleProperty, widthProperty, colorProperty);
            }
        }
    }

    private void handleBorderValue(CSSStyleDeclarationImpl cssStyleDeclaration, int i, CSSValue item, String value) {
        if (HtmlConstants.BORDER_STYLES.contains(value = value.toLowerCase())) {
            BoxProperty.BORDER_STYLE.setValues(cssStyleDeclaration, i, item);
        } else if (NamedBorderWidth.contains(value)) {
            BoxProperty.BORDER_WIDTH.setValues(cssStyleDeclaration, i, item);
        } else if (Character.isDigit(value.charAt(0))) {
            CSSLength width = CSSLength.of(value);
            if (width.isValid()) {
                BoxProperty.BORDER_WIDTH.setValues(cssStyleDeclaration, i, item);
            }
        } else {
            BoxProperty.BORDER_COLOR.setValues(cssStyleDeclaration, i, item);
        }
    }

    private void handleBorderValue(CSSStyleDeclarationImpl cssStyleDeclaration, int i, CSSValue item, String value, String styleProperty, String widthProperty, String colorProperty) {
        if (HtmlConstants.BORDER_STYLES.contains(value = value.toLowerCase())) {
            cssStyleDeclaration.getProperties().add(i, new Property(styleProperty, item, false));
        } else if (NamedBorderWidth.contains(value)) {
            cssStyleDeclaration.getProperties().add(i, new Property(widthProperty, item, false));
        } else if (Character.isDigit(value.charAt(0))) {
            CSSLength width = CSSLength.of(value);
            if (width.isValid()) {
                cssStyleDeclaration.getProperties().add(i, new Property(widthProperty, item, false));
            }
        } else {
            cssStyleDeclaration.getProperties().add(i, new Property(colorProperty, item, false));
        }
    }

    private void splitFont(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl cssStyleDeclaration, int i) {
        if (length == 0) {
            return;
        }
        boolean styleHandled = false;
        boolean sizeHandled = false;
        block0: for (int j = 0; j < length; ++j) {
            CSSValue item = valueList.item(j);
            String value = item.getCssText();
            String lowerCase = value.toLowerCase();
            if (!styleHandled && HtmlConstants.FONT_STYLES.contains(lowerCase)) {
                cssStyleDeclaration.getProperties().add(i, new Property("font-style", item, false));
                styleHandled = true;
                continue;
            }
            if (HtmlConstants.FONT_VARIANTS.contains(lowerCase)) {
                cssStyleDeclaration.getProperties().add(i, new Property("font-variant-caps", item, false));
                continue;
            }
            if (HtmlConstants.FONT_WEIGHTS.contains(lowerCase) || NumberUtils.isParsable((String)value)) {
                cssStyleDeclaration.getProperties().add(i, new Property("font-weight", item, false));
                continue;
            }
            if ("/".equals(value)) {
                CSSValue fontSize = valueList.item(j - 1);
                cssStyleDeclaration.getProperties().add(i, new Property("font-size", fontSize, false));
                sizeHandled = true;
                if (++j >= length) continue;
                CSSValue lineHeight = valueList.item(j);
                cssStyleDeclaration.getProperties().add(i, new Property("line-height", lineHeight, false));
                continue;
            }
            if (",".equals(value)) {
                CSSValue firstFont = valueList.item(j - 1);
                if (!sizeHandled) {
                    CSSValue fontSize = valueList.item(j - 2);
                    cssStyleDeclaration.getProperties().add(i, new Property("font-size", fontSize, false));
                }
                if (HtmlConstants.isMajorFont(firstFont.getCssText())) {
                    cssStyleDeclaration.getProperties().add(i, new Property("font-family", firstFont, false));
                    break;
                }
                ++j;
                while (j < length) {
                    CSSValue fontFamily = valueList.item(j);
                    if (HtmlConstants.isMajorFont(fontFamily.getCssText())) {
                        cssStyleDeclaration.getProperties().add(i, new Property("font-family", fontFamily, false));
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            if (j != length - 1) continue;
            cssStyleDeclaration.getProperties().add(i, new Property("font-family", item, false));
        }
    }

    private void splitBox(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl cssStyleDeclaration, int i, BoxProperty boxProperty) {
        switch (length) {
            case 0: 
            case 1: {
                if (!StringUtils.isNotBlank((CharSequence)valueList.getCssText())) break;
                boxProperty.setValues(cssStyleDeclaration, i, (CSSValue)valueList);
                break;
            }
            case 2: {
                boxProperty.setValues(cssStyleDeclaration, i, valueList.item(0), valueList.item(1));
                break;
            }
            case 3: {
                boxProperty.setValues(cssStyleDeclaration, i, valueList.item(0), valueList.item(1), valueList.item(2));
                break;
            }
            case 4: {
                boxProperty.setValues(cssStyleDeclaration, i, valueList.item(0), valueList.item(1), valueList.item(2), valueList.item(3));
            }
        }
    }
}

