/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html;

import com.deepoove.poi.render.RenderContext;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlString;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;
import org.ddr.poi.html.util.Colors;
import org.ddr.poi.html.util.InlineStyle;
import org.ddr.poi.html.util.NamedFontSize;
import org.ddr.poi.html.util.NumberingContext;
import org.ddr.poi.html.util.RenderUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STThemeColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalAlignRun;

public class HtmlRenderContext
extends RenderContext<String> {
    private static final CSSLength DEFAULT_FONT_SIZE = new CSSLength(12.0, CSSLengthUnit.PT);
    private static final String DEFAULT_HYPERLINK_COLOR = "0563C1";
    private LinkedList<IBodyElement> closestBodyStack = new LinkedList();
    private LinkedList<IBody> ancestors = new LinkedList();
    private LinkedList<InlineStyle> inlineStyles = new LinkedList();
    private LinkedList<Integer> fontSizesInHalfPoints = new LinkedList();
    private final NumberingContext numberingContext = new NumberingContext((XWPFDocument)this.getXWPFDocument());
    private final CSSLength defaultFontSize;
    private final CSSLength pageWidth;
    private final CSSLength pageHeight;
    private final CSSLength marginTop;
    private final CSSLength marginRight;
    private final CSSLength marginBottom;
    private final CSSLength marginLeft;
    private final int availablePageWidth;
    private final int availablePageHeight;
    private XWPFRun currentRun;
    private String globalFont;
    private BigInteger globalFontSize;

    public HtmlRenderContext(RenderContext<String> context) {
        super(context.getEleTemplate(), context.getData(), context.getTemplate());
        CTSectPr sectPr = this.getXWPFDocument().getDocument().getBody().getSectPr();
        CTPageSz pgSz = sectPr.getPgSz();
        int w = pgSz.getW().intValue();
        this.pageWidth = new CSSLength(w, CSSLengthUnit.TWIP);
        int h = pgSz.getH().intValue();
        this.pageHeight = new CSSLength(h, CSSLengthUnit.TWIP);
        CTPageMar pgMar = sectPr.getPgMar();
        int top = pgMar.getTop().intValue();
        this.marginTop = new CSSLength(top, CSSLengthUnit.TWIP);
        int right = pgMar.getRight().intValue();
        this.marginRight = new CSSLength(right, CSSLengthUnit.TWIP);
        int bottom = pgMar.getBottom().intValue();
        this.marginBottom = new CSSLength(bottom, CSSLengthUnit.TWIP);
        int left = pgMar.getLeft().intValue();
        this.marginLeft = new CSSLength(left, CSSLengthUnit.TWIP);
        this.availablePageWidth = new CSSLength(w - left - right, CSSLengthUnit.TWIP).toEMU();
        this.availablePageHeight = new CSSLength(h - top - bottom, CSSLengthUnit.TWIP).toEMU();
        int fontSize = this.getXWPFDocument().getStyles().getDefaultRunStyle().getFontSize();
        this.defaultFontSize = fontSize > 0 ? new CSSLength(fontSize, CSSLengthUnit.PT) : DEFAULT_FONT_SIZE;
    }

    public IBody getContainer() {
        IBody container = this.ancestors.peek();
        return container == null ? super.getContainer() : container;
    }

    public void pushContainer(IBody body) {
        this.ancestors.push(body);
    }

    public void popContainer() {
        this.ancestors.pop();
    }

    public IBodyElement getClosestBody() {
        IBodyElement body = this.closestBodyStack.peek();
        return body == null ? (IBodyElement)this.getRun().getParent() : body;
    }

    public void pushClosestBody(IBodyElement body) {
        this.closestBodyStack.push(body);
    }

    public void popClosestBody() {
        this.closestBodyStack.pop();
    }

    public void replaceClosestBody(IBodyElement body) {
        if (!this.closestBodyStack.isEmpty()) {
            this.closestBodyStack.pop();
        }
        this.closestBodyStack.push(body);
    }

    public XWPFParagraph getClosestParagraph() {
        IBodyElement body = this.closestBodyStack.peek();
        if (body == null) {
            return (XWPFParagraph)this.getRun().getParent();
        }
        switch (body.getElementType()) {
            case PARAGRAPH: {
                return (XWPFParagraph)body;
            }
            case TABLE: {
                XmlCursor xmlCursor = ((XWPFTable)body).getCTTbl().newCursor();
                xmlCursor.toEndToken();
                xmlCursor.toNextToken();
                XWPFParagraph paragraph = this.getContainer().insertNewParagraph(xmlCursor);
                xmlCursor.dispose();
                return paragraph;
            }
        }
        throw new IllegalStateException("Impossible");
    }

    public void startHyperlink(String uri) {
        this.currentRun = this.getClosestParagraph().createHyperlinkRun(uri);
    }

    public void endHyperlink() {
        this.currentRun = null;
    }

    public CTR newRun() {
        if (this.currentRun instanceof XWPFHyperlinkRun) {
            CTR ctr;
            XmlCursor xmlCursor = this.currentRun.getCTR().newCursor();
            if (xmlCursor.toFirstChild()) {
                xmlCursor.dispose();
                ctr = ((XWPFHyperlinkRun)this.currentRun).getCTHyperlink().addNewR();
            } else {
                ctr = this.currentRun.getCTR();
            }
            this.initHyperlinkStyle(ctr);
            return ctr;
        }
        this.currentRun = this.getClosestParagraph().createRun();
        return this.currentRun.getCTR();
    }

    private void initHyperlinkStyle(CTR ctr) {
        CTRPr rPr = RenderUtils.getRPr(ctr);
        CTColor ctColor = rPr.addNewColor();
        ctColor.setVal((Object)DEFAULT_HYPERLINK_COLOR);
        ctColor.setThemeColor(STThemeColor.HYPERLINK);
        rPr.addNewU().setVal(STUnderline.SINGLE);
    }

    public XWPFTable getClosestTable() {
        for (IBodyElement body : this.closestBodyStack) {
            if (!(body instanceof XWPFTable)) continue;
            return (XWPFTable)body;
        }
        throw new IllegalStateException("No table in stack");
    }

    public void pushInlineStyle(CSSStyleDeclarationImpl inlineStyle, boolean block) {
        String newFontSize = inlineStyle.getFontSize();
        int fontSize = Integer.MIN_VALUE;
        if (StringUtils.isNotBlank((CharSequence)newFontSize)) {
            NamedFontSize namedFontSize = NamedFontSize.of(newFontSize);
            if (namedFontSize != null) {
                fontSize = namedFontSize.getSize().toHalfPoints();
            } else if ("smaller".equalsIgnoreCase(newFontSize)) {
                int inheritedFontSize = this.getInheritedFontSizeInHalfPoints();
                fontSize = RenderUtils.smallerFontSizeInHalfPoints(inheritedFontSize);
            } else if ("larger".equalsIgnoreCase(newFontSize)) {
                int inheritedFontSize = this.getInheritedFontSizeInHalfPoints();
                fontSize = RenderUtils.largerFontSizeInHalfPoints(inheritedFontSize);
            } else {
                CSSLength cssLength = CSSLength.of(newFontSize);
                if (cssLength.isValid()) {
                    if (cssLength.getUnit() == CSSLengthUnit.PERCENT) {
                        fontSize = (int)Math.rint((double)this.getInheritedFontSizeInHalfPoints() * cssLength.getValue() * cssLength.getUnit().absoluteFactor());
                    } else {
                        int emu = this.lengthToEMU(cssLength);
                        fontSize = emu * 2 / 12700;
                    }
                }
            }
        }
        this.fontSizesInHalfPoints.push(fontSize);
        this.inlineStyles.push(new InlineStyle(inlineStyle, block));
    }

    public void popInlineStyle() {
        this.fontSizesInHalfPoints.pop();
        this.inlineStyles.pop();
    }

    public CSSStyleDeclarationImpl currentElementStyle() {
        InlineStyle inlineStyle = this.inlineStyles.peek();
        return inlineStyle == null ? RenderUtils.EMPTY_STYLE : inlineStyle.getDeclaration();
    }

    public String getPropertyValue(String property) {
        return this.getPropertyValue(property, false, false);
    }

    public String getPropertyValue(String property, boolean inlineOnly) {
        return this.getPropertyValue(property, false, inlineOnly);
    }

    public String getPropertyValue(String property, boolean caseSensitive, boolean inlineOnly) {
        for (InlineStyle inlineStyle : this.inlineStyles) {
            if (inlineOnly && inlineStyle.isBlock()) break;
            String propertyValue = inlineStyle.getDeclaration().getPropertyValue(property);
            if (!StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
            return caseSensitive ? propertyValue : propertyValue.toLowerCase();
        }
        return "";
    }

    public CSSLength getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public int getInheritedFontSizeInHalfPoints() {
        for (Integer fontSize : this.fontSizesInHalfPoints) {
            if (fontSize <= 0) continue;
            return fontSize;
        }
        return this.defaultFontSize.toHalfPoints();
    }

    public int getAvailableWidthInEMU() {
        IBody container = this.getContainer();
        if (container.getPartType() == BodyType.DOCUMENT) {
            return this.availablePageWidth;
        }
        return RenderUtils.getAvailableWidthInEMU(container);
    }

    public int computeLengthInEMU(String length, String maxLength, int naturalEMU, int parentEMU) {
        CSSLength cssLength;
        int emu = naturalEMU;
        if (length.length() > 0 && (cssLength = CSSLength.of(length)).isValid()) {
            emu = this.computeLengthInEMU(cssLength, naturalEMU, parentEMU);
        }
        if (maxLength.length() > 0 && (cssLength = CSSLength.of(maxLength)).isValid()) {
            int maxEMU = this.computeLengthInEMU(cssLength, naturalEMU, parentEMU);
            emu = Math.min(maxEMU, emu);
        }
        return Math.min(emu, parentEMU);
    }

    public int computeLengthInEMU(CSSLength cssLength, int naturalEMU, int parentEMU) {
        int length = cssLength.getUnit() == CSSLengthUnit.PERCENT ? (parentEMU != Integer.MAX_VALUE ? (int)((double)parentEMU * cssLength.getValue() * cssLength.getUnit().absoluteFactor()) : naturalEMU) : this.lengthToEMU(cssLength);
        return length;
    }

    public void renderText(String text) {
        CTR ctr = this.newRun();
        CTText ctText = ctr.addNewT();
        ctText.setStringValue(text);
        RenderUtils.preserveSpaces((XmlString)ctText);
        this.applyTextStyle(ctr);
        if (!(this.currentRun instanceof XWPFHyperlinkRun)) {
            this.currentRun = null;
        }
    }

    private void applyTextStyle(CTR ctr) {
        String verticalAlign;
        String textDecoration;
        String caps;
        String color;
        String fontFamily;
        CTRPr rPr = RenderUtils.getRPr(ctr);
        String string = fontFamily = StringUtils.isBlank((CharSequence)this.globalFont) ? this.getPropertyValue("font-family") : this.globalFont;
        if (StringUtils.isNotBlank((CharSequence)fontFamily)) {
            CTFonts ctFonts = rPr.addNewRFonts();
            ctFonts.setAscii(fontFamily);
            ctFonts.setHAnsi(fontFamily);
            ctFonts.setCs(fontFamily);
            ctFonts.setEastAsia(fontFamily);
        }
        if (this.globalFontSize == null) {
            String fontSize = this.getPropertyValue("font-size");
            if (StringUtils.isNotBlank((CharSequence)fontSize)) {
                int sz = this.getInheritedFontSizeInHalfPoints();
                rPr.addNewSz().setVal(BigInteger.valueOf(sz));
            }
        } else {
            rPr.addNewSz().setVal(this.globalFontSize);
        }
        String fontWeight = this.getPropertyValue("font-weight");
        if (fontWeight.contains("bold")) {
            rPr.addNewB();
        } else if (NumberUtils.isParsable((String)fontWeight) && Float.parseFloat(fontWeight) > 500.0f) {
            rPr.addNewB();
        }
        String fontStyle = this.getPropertyValue("font-style");
        if ("italic".equals(fontStyle) || "oblique".equals(fontStyle)) {
            rPr.addNewI();
        }
        if (StringUtils.isNotBlank((CharSequence)(color = this.getPropertyValue("color")))) {
            String hex = Colors.fromStyle(color);
            RenderUtils.getColor(rPr).setVal((Object)hex);
        }
        if ("small-caps".equals(caps = this.getPropertyValue("font-variant-caps"))) {
            rPr.addNewSmallCaps();
        }
        if (StringUtils.contains((CharSequence)(textDecoration = this.getPropertyValue("text-decoration-line")), (CharSequence)"line-through")) {
            rPr.addNewStrike();
        }
        if (StringUtils.contains((CharSequence)textDecoration, (CharSequence)"underline")) {
            CTUnderline ctUnderline = RenderUtils.getUnderline(rPr);
            String textDecorationStyle = this.getPropertyValue("text-decoration-style");
            ctUnderline.setVal(RenderUtils.underline(textDecorationStyle));
            String textDecorationColor = this.getPropertyValue("text-decoration-color");
            if (StringUtils.isNotBlank((CharSequence)textDecorationColor)) {
                String hex = Colors.fromStyle(textDecorationColor);
                ctUnderline.setColor((Object)hex);
            }
        }
        if ("super".equals(verticalAlign = this.getPropertyValue("vertical-align"))) {
            rPr.addNewVertAlign().setVal(STVerticalAlignRun.SUPERSCRIPT);
        } else if ("sub".equals(verticalAlign)) {
            rPr.addNewVertAlign().setVal(STVerticalAlignRun.SUBSCRIPT);
        }
        String visibility = this.getPropertyValue("visibility");
        if ("hidden".equals(visibility) || "collapse".equals(visibility)) {
            rPr.addNewVanish();
        }
    }

    public void renderPicture(InputStream pictureData, int pictureType, String filename, int width, int height) throws IOException, InvalidFormatException {
        CTR ctr = this.newRun();
        this.currentRun.addPicture(pictureData, pictureType, filename, width, height);
        CTR r = this.currentRun.getCTR();
        if (r != ctr) {
            int lastDrawingIndex = r.sizeOfDrawingArray() - 1;
            CTDrawing drawing = r.getDrawingArray(lastDrawingIndex);
            ctr.setDrawingArray(new CTDrawing[]{drawing});
            r.removeDrawing(lastDrawingIndex);
        }
    }

    public int lengthToEMU(CSSLength length) {
        double emu;
        if (!length.isValid()) {
            throw new UnsupportedOperationException("Invalid CSS length");
        }
        if (!length.getUnit().isRelative()) {
            return length.toEMU();
        }
        switch (length.getUnit()) {
            case REM: {
                emu = length.unitValue() * (double)this.getDefaultFontSize().toEMU();
                break;
            }
            case EM: {
                emu = length.unitValue() * (double)this.getInheritedFontSizeInHalfPoints() * 12700.0 / 2.0;
                break;
            }
            case VW: {
                emu = length.unitValue() * (double)this.getPageWidth().toEMU();
                break;
            }
            case VH: {
                emu = length.unitValue() * (double)this.getPageHeight().toEMU();
                break;
            }
            case VMIN: {
                emu = length.unitValue() * (double)Math.min(this.getPageWidth().toEMU(), this.getPageHeight().toEMU());
                break;
            }
            case VMAX: {
                emu = length.unitValue() * (double)Math.max(this.getPageWidth().toEMU(), this.getPageHeight().toEMU());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can not convert to EMU with length: " + length);
            }
        }
        return (int)Math.rint(emu);
    }

    public NumberingContext getNumberingContext() {
        return this.numberingContext;
    }

    public CSSLength getPageWidth() {
        return this.pageWidth;
    }

    public CSSLength getPageHeight() {
        return this.pageHeight;
    }

    public CSSLength getMarginTop() {
        return this.marginTop;
    }

    public CSSLength getMarginRight() {
        return this.marginRight;
    }

    public CSSLength getMarginBottom() {
        return this.marginBottom;
    }

    public CSSLength getMarginLeft() {
        return this.marginLeft;
    }

    public int getAvailablePageWidth() {
        return this.availablePageWidth;
    }

    public int getAvailablePageHeight() {
        return this.availablePageHeight;
    }

    public XWPFRun getCurrentRun() {
        return this.currentRun;
    }

    public String getGlobalFont() {
        return this.globalFont;
    }

    public BigInteger getGlobalFontSize() {
        return this.globalFontSize;
    }

    public void setGlobalFont(String globalFont) {
        this.globalFont = globalFont;
    }

    public void setGlobalFontSize(BigInteger globalFontSize) {
        this.globalFontSize = globalFontSize;
    }
}

