/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.SslConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005MsAB\f\u0019\u0011\u0003Q\u0002E\u0002\u0004#1!\u0005!d\t\u0005\u0006U\u0005!\t\u0001\f\u0005\b[\u0005\u0011\r\u0011\"\u0003/\u0011\u00199\u0014\u0001)A\u0005_!9\u0001(\u0001b\u0001\n\u0013I\u0004B\u0002#\u0002A\u0003%!HB\u0003#1\u0001aR\t\u0003\u0005Q\u000f\t\u0005\t\u0015!\u0003R\u0011\u0015Qs\u0001\"\u0001Z\u0011\u001davA1A\u0005\nuCa!Y\u0004!\u0002\u0013q\u0006b\u00022\b\u0005\u0004%Ia\u0019\u0005\u0007O\u001e\u0001\u000b\u0011\u00023\t\u0011!<\u0001R1A\u0005\n%Dqa]\u0004C\u0002\u0013%A\u000fC\u0004\u0002\b\u001d\u0001\u000b\u0011B;\t\u0013\u0005%qA1A\u0005\n\u0005-\u0001\u0002CA\f\u000f\u0001\u0006I!!\u0004\t\u0011\u0005eqA1A\u0005\nuCq!a\u0007\bA\u0003%a\fC\u0004\u0002\u001e\u001d!\t!a\b\t\u000f\u0005mr\u0001\"\u0003\u0002>\u0005\u00112k\u001d7D_:$X\r\u001f;t\r\u0006\u001cGo\u001c:z\u0015\tI\"$\u0001\u0003vi&d'BA\u000e\u001d\u0003\u0011AG\u000f\u001e9\u000b\u0005uq\u0012aB4bi2Lgn\u001a\u0006\u0002?\u0005\u0011\u0011n\u001c\t\u0003C\u0005i\u0011\u0001\u0007\u0002\u0013'Nd7i\u001c8uKb$8OR1di>\u0014\u0018p\u0005\u0002\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002A\u00051B)\u001a4bk2$8k\u001d7TK\u000e,(/\u001a*b]\u0012|W.F\u00010!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0019\u0003\u0019M+7-\u001e:f%\u0006tGm\\7\u0002/\u0011+g-Y;miN\u001bHnU3dkJ,'+\u00198e_6\u0004\u0013aA!q]V\t!\b\u0005\u0002<\u00056\tAH\u0003\u0002>}\u0005\u00191o\u001d7\u000b\u0005}\u0002\u0015a\u00025b]\u0012dWM\u001d\u0006\u0003\u0003z\tQA\\3uifL!a\u0011\u001f\u00033\u0005\u0003\b\u000f\\5dCRLwN\u001c)s_R|7m\u001c7D_:4\u0017nZ\u0001\u0005\u0003Bt\u0007eE\u0002\bI\u0019\u0003\"a\u0012(\u000e\u0003!S!!\u0013&\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005-c\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u00035\u000b1aY8n\u0013\ty\u0005JA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\ngNd7i\u001c8gS\u001e\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\r\r|gNZ5h\u0015\t1F$\u0001\u0003d_J,\u0017B\u0001-T\u0005A\u00196\u000f\\\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0002[7B\u0011\u0011e\u0002\u0005\u0006!&\u0001\r!U\u0001\u000bkN,w\n]3o'NdW#\u00010\u0011\u0005\u0015z\u0016B\u00011'\u0005\u001d\u0011un\u001c7fC:\f1\"^:f\u001fB,gnU:mA\u0005A2o\u001d7TKN\u001c\u0018n\u001c8US6,w.\u001e;TK\u000e|g\u000eZ:\u0016\u0003\u0011\u0004\"!J3\n\u0005\u00194#\u0001\u0002'p]\u001e\f\u0011d]:m'\u0016\u001c8/[8o)&lWm\\;u'\u0016\u001cwN\u001c3tA\u0005AB)\u001a4bk2$(*\u0019<b'Nd\u0007+\u0019:b[\u0016$XM]:\u0016\u0003)\u0004\"a[9\u000e\u00031T!!P7\u000b\u00059|\u0017a\u00018fi*\t\u0001/A\u0003kCZ\f\u00070\u0003\u0002sY\ni1k\u0015'QCJ\fW.\u001a;feN\f\u0001#\u001a8bE2,G\r\u0015:pi>\u001cw\u000e\\:\u0016\u0003U\u00042!\n<y\u0013\t9hEA\u0003BeJ\f\u0017\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005m4S\"\u0001?\u000b\u0005u\\\u0013A\u0002\u001fs_>$h(\u0003\u0002\u0000M\u00051\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a \u0014\u0002#\u0015t\u0017M\u00197fIB\u0013x\u000e^8d_2\u001c\b%A\nf]\u0006\u0014G.\u001a3DSBDWM]*vSR,7/\u0006\u0002\u0002\u000eA)\u0011qBA\nq6\u0011\u0011\u0011\u0003\u0006\u00033MJA!!\u0006\u0002\u0012\t!A*[:u\u0003Q)g.\u00192mK\u0012\u001c\u0015\u000e\u001d5feN+\u0018\u000e^3tA\u0005!Ro]3Pa\u0016t7k\u001d7GS:\fG.\u001b>feN\fQ#^:f\u001fB,gnU:m\r&t\u0017\r\\5{KJ\u001c\b%\u0001\boK^\u001c6\u000f\\\"p]R,\u0007\u0010^:\u0015\r\u0005\u0005\u0012qEA\u0016!\r\t\u00131E\u0005\u0004\u0003KA\"aC*tY\u000e{g\u000e^3yiNDa!!\u000b\u0016\u0001\u0004q\u0016\u0001\u00045uiB\u0014TI\\1cY\u0016$\u0007bBA\u0017+\u0001\u0007\u0011qF\u0001\u0019a\u0016\u0014Xk]3s\u0017\u0016LX*\u00198bO\u0016\u0014h)Y2u_JL\b#B\u0013\u00022\u0005U\u0012bAA\u001aM\t1q\n\u001d;j_:\u00042a[A\u001c\u0013\r\tI\u0004\u001c\u0002\u0012\u0017\u0016LX*\u00198bO\u0016\u0014h)Y2u_JL\u0018\u0001\u00058fo*#7nU:m\u0007>tG/\u001a=u)\u0019\ty$!\u0012\u0002PA\u00191(!\u0011\n\u0007\u0005\rCH\u0001\u0006Tg2\u001cuN\u001c;fqRDq!a\u0012\u0017\u0001\u0004\tI%A\u0007kI.\u001c6\u000f\\\"p]R,\u0007\u0010\u001e\t\u0004W\u0006-\u0013bAA'Y\nQ1k\u0015'D_:$X\r\u001f;\t\r\u0005Ec\u00031\u0001;\u0003\r\t\u0007O\u001c")
public class SslContextsFactory
implements StrictLogging {
    private SSLParameters DefaultJavaSslParameters;
    private final SslConfiguration sslConfig;
    private final boolean useOpenSsl;
    private final long sslSessionTimeoutSeconds;
    private final String[] enabledProtocols;
    private final List<String> enabledCipherSuites;
    private final boolean useOpenSslFinalizers;
    private Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    private SSLParameters DefaultJavaSslParameters$lzycompute() {
        SslContextsFactory sslContextsFactory = this;
        synchronized (sslContextsFactory) {
            if (!this.bitmap$0) {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, null, null);
                this.DefaultJavaSslParameters = context.getDefaultSSLParameters();
                this.bitmap$0 = true;
            }
        }
        return this.DefaultJavaSslParameters;
    }

    private SSLParameters DefaultJavaSslParameters() {
        if (!this.bitmap$0) {
            return this.DefaultJavaSslParameters$lzycompute();
        }
        return this.DefaultJavaSslParameters;
    }

    private String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    private List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    private boolean useOpenSslFinalizers() {
        return this.useOpenSslFinalizers;
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable)() -> $this.sslConfig.keyManagerFactory());
        Option tmf = this.sslConfig.trustManagerFactory().orElse((Function0 & Serializable)() -> {
            if ($this.sslConfig.useInsecureTrustManager()) {
                return new Some((Object)InsecureTrustManagerFactory.INSTANCE);
            }
            return None$.MODULE$;
        });
        if (this.useOpenSsl()) {
            SslProvider provider = this.useOpenSslFinalizers() ? SslProvider.OPENSSL : SslProvider.OPENSSL_REFCNT;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(provider);
            Object object = this.sslConfig.sessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.sslConfig.sessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.sslConfig.sessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())) ? sslContextBuilder.protocols(this.enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.sslConfig.enabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            kmf.foreach((Function1 & Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            tmf.foreach((Function1 & Serializable)x$1 -> sslContextBuilder.trustManager(x$1));
            SslContext sslContext = sslContextBuilder.build();
            None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
            return new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        SSLContext jdkSslContext = SSLContext.getInstance("TLS");
        jdkSslContext.init((KeyManager[])kmf.map((Function1 & Serializable)x$1 -> x$1.getKeyManagers()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (TrustManager[])tmf.map((Function1 & Serializable)x$2 -> x$2.getTrustManagers()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
        SslContext sslContext = this.newJdkSslContext(jdkSslContext, null);
        None$ alpnSslContext = http2Enabled ? new Some((Object)this.newJdkSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
        return new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
    }

    private SslContext newJdkSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new JdkSslContext(jdkSslContext, true, this.enabledCipherSuites().isEmpty() ? null : this.enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn, ClientAuth.NONE, ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())) ? this.enabledProtocols() : null, false);
    }

    public SslContextsFactory(SslConfiguration sslConfig) {
        List list;
        String[] stringArray;
        boolean bl;
        this.sslConfig = sslConfig;
        StrictLogging.$init$((StrictLogging)this);
        if (sslConfig.useOpenSsl()) {
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = available;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
        this.sslSessionTimeoutSeconds = sslConfig.sessionTimeout().toSeconds();
        if (this.useOpenSsl()) {
            stringArray = (String[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            Set supportedProtocols = Predef$.MODULE$.wrapRefArray((Object[])this.DefaultJavaSslParameters().getProtocols()).toSet();
            stringArray = this.enabledProtocols = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)supportedProtocols.contains((Object)elem)));
        }
        if (this.useOpenSsl()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sslConfig.enabledCipherSuites()).asJava();
        } else {
            String[] supportedCipherSuites = this.DefaultJavaSslParameters().getCipherSuites();
            Object object = Predef$.MODULE$.refArrayOps((Object[])supportedCipherSuites);
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sslConfig.enabledCipherSuites().filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(object, (Object)elem)))).asJava();
        }
        this.enabledCipherSuites = list;
        this.useOpenSslFinalizers = sslConfig.useOpenSslFinalizers();
        Statics.releaseFence();
    }
}

