/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.WebApplicationExceptionCatchingFilter;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class AuthDynamicFeature
implements DynamicFeature {
    private final ContainerRequestFilter authFilter;
    private final Class<? extends ContainerRequestFilter> authFilterClass;

    public AuthDynamicFeature(ContainerRequestFilter authFilter) {
        this.authFilter = authFilter;
        this.authFilterClass = null;
    }

    public AuthDynamicFeature(Class<? extends ContainerRequestFilter> authFilterClass) {
        this.authFilter = null;
        this.authFilterClass = authFilterClass;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        boolean annotationOnMethod;
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Annotation[][] parameterAnnotations = am.getParameterAnnotations();
        Class[] parameterTypes = am.getParameterTypes();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof Auth)) continue;
                if (parameterTypes[i].equals(Optional.class) && this.authFilter != null) {
                    context.register((Object)new WebApplicationExceptionCatchingFilter(this.authFilter));
                    return;
                }
                this.registerAuthFilter(context);
                return;
            }
        }
        boolean annotationOnClass = resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class) != null || resourceInfo.getResourceClass().getAnnotation(PermitAll.class) != null;
        boolean bl = annotationOnMethod = am.isAnnotationPresent(RolesAllowed.class) || am.isAnnotationPresent(DenyAll.class) || am.isAnnotationPresent(PermitAll.class);
        if (annotationOnClass || annotationOnMethod) {
            this.registerAuthFilter(context);
        }
    }

    private void registerAuthFilter(FeatureContext context) {
        if (this.authFilter != null) {
            context.register((Object)this.authFilter);
        } else if (this.authFilterClass != null) {
            context.register(this.authFilterClass);
        }
    }
}

