/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.StripShellResponseHandler;
import io.cloudsoft.winrm4j.client.WinRm;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.client.WinRmService;
import io.cloudsoft.winrm4j.client.ntlm.SpNegoNTLMSchemeFactory;
import io.cloudsoft.winrm4j.client.shell.CommandLine;
import io.cloudsoft.winrm4j.client.shell.CommandStateType;
import io.cloudsoft.winrm4j.client.shell.DesiredStreamType;
import io.cloudsoft.winrm4j.client.shell.EnvironmentVariable;
import io.cloudsoft.winrm4j.client.shell.EnvironmentVariableList;
import io.cloudsoft.winrm4j.client.shell.Receive;
import io.cloudsoft.winrm4j.client.shell.ReceiveResponse;
import io.cloudsoft.winrm4j.client.shell.Shell;
import io.cloudsoft.winrm4j.client.shell.StreamType;
import io.cloudsoft.winrm4j.client.transfer.ResourceCreated;
import io.cloudsoft.winrm4j.client.wsman.CommandResponse;
import io.cloudsoft.winrm4j.client.wsman.DeleteResponse;
import io.cloudsoft.winrm4j.client.wsman.Locale;
import io.cloudsoft.winrm4j.client.wsman.OptionSetType;
import io.cloudsoft.winrm4j.client.wsman.OptionType;
import io.cloudsoft.winrm4j.client.wsman.SelectorSetType;
import io.cloudsoft.winrm4j.client.wsman.SelectorType;
import io.cloudsoft.winrm4j.client.wsman.Signal;
import io.cloudsoft.winrm4j.client.wsman.SignalResponse;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WinRmClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)WinRmClient.class.getName());
    private static final String COMMAND_STATE_DONE = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/CommandState/Done";
    private static final int MAX_ENVELOPER_SIZE = 153600;
    private static final String RESOURCE_URI = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd";
    private static final String WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED = "2150858793";
    private static final String WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND = "2150858843";
    private final String authenticationScheme;
    private URL endpoint;
    private String domain;
    private String username;
    private String password;
    private String workingDirectory;
    private Locale locale;
    private String operationTimeout;
    private Long receiveTimeout;
    private Integer retriesForConnectionFailures;
    private Map<String, String> environment;
    private WinRmClientContext context;
    private boolean cleanupContext;
    private WinRm winrm;
    private String shellId;
    private SelectorSetType shellSelector;
    private int numberOfReceiveCalls;
    private boolean disableCertificateChecks;
    private HostnameVerifier hostnameVerifier;

    public static Builder builder(URL endpoint) {
        return new Builder(endpoint, "NTLM");
    }

    public static Builder builder(String endpoint) {
        return new Builder(endpoint, "NTLM");
    }

    public static Builder builder(URL endpoint, String authenticationScheme) {
        return new Builder(endpoint, authenticationScheme);
    }

    public static Builder builder(String endpoint, String authenticationScheme) {
        return new Builder(endpoint, authenticationScheme);
    }

    private WinRmClient(URL endpoint, String authenticationScheme) {
        this.authenticationScheme = authenticationScheme != null ? authenticationScheme : "NTLM";
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int command(String cmd, Writer out, Writer err) {
        WinRmClient.checkNotNull(cmd, "command");
        WinRm service = this.getService();
        CommandLine cmdLine = new CommandLine();
        cmdLine.setCommand(cmd);
        OptionSetType optSetCmd = new OptionSetType();
        OptionType optConsolemodeStdin = new OptionType();
        optConsolemodeStdin.setName("WINRS_CONSOLEMODE_STDIN");
        optConsolemodeStdin.setValue("TRUE");
        optSetCmd.getOption().add(optConsolemodeStdin);
        OptionType optSkipCmdShell = new OptionType();
        optSkipCmdShell.setName("WINRS_SKIP_CMD_SHELL");
        optSkipCmdShell.setValue("FALSE");
        optSetCmd.getOption().add(optSkipCmdShell);
        this.numberOfReceiveCalls = 0;
        this.setActionToContext((BindingProvider)service, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Command");
        CommandResponse cmdResponse = service.command(cmdLine, RESOURCE_URI, 153600, this.operationTimeout, this.locale, this.shellSelector, optSetCmd);
        String commandId = cmdResponse.getCommandId();
        try {
            int n = this.receiveCommand(commandId, out, err);
            return n;
        }
        finally {
            try {
                this.releaseCommand(commandId);
            }
            catch (SOAPFaultException soapFault) {
                this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND);
            }
        }
    }

    private void setActionToContext(BindingProvider bp, String action) {
        AttributedURIType attrUri = new AttributedURIType();
        attrUri.setValue(action);
        AddressingProperties addrProps = this.getAddressingProperties(bp);
        addrProps.setAction(attrUri);
    }

    private AddressingProperties getAddressingProperties(BindingProvider bp) {
        String ADDR_CONTEXT = "javax.xml.ws.addressing.context";
        Map reqContext = bp.getRequestContext();
        if (reqContext == null) {
            throw new NullPointerException("Unable to load request context; delegate load failed");
        }
        AddressingProperties addrProps = (AddressingProperties)reqContext.get(ADDR_CONTEXT);
        if (addrProps == null) {
            throw new NullPointerException("Unable to load request context " + ADDR_CONTEXT + "; are the addressing classes installed (you may need <feature>cxf-ws-addr</feature> if running in osgi)");
        }
        return addrProps;
    }

    private void releaseCommand(String commandId) {
        final Signal signal = new Signal();
        signal.setCommandId(commandId);
        signal.setCode("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/signal/terminate");
        this.winrmCallRetryConnFailure(new CallableFunction<SignalResponse>(){

            @Override
            public SignalResponse call() {
                WinRmClient.this.setActionToContext((BindingProvider)WinRmClient.this.winrm, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Signal");
                return WinRmClient.this.winrm.signal(signal, WinRmClient.RESOURCE_URI, 153600, WinRmClient.this.operationTimeout, WinRmClient.this.locale, WinRmClient.this.shellSelector);
            }
        });
    }

    private int receiveCommand(String commandId, Writer out, Writer err) {
        while (true) {
            final Receive receive = new Receive();
            DesiredStreamType stream = new DesiredStreamType();
            stream.setCommandId(commandId);
            stream.setValue("stdout stderr");
            receive.setDesiredStream(stream);
            try {
                ++this.numberOfReceiveCalls;
                ReceiveResponse receiveResponse = this.winrmCallRetryConnFailure(new CallableFunction<ReceiveResponse>(){

                    @Override
                    public ReceiveResponse call() {
                        WinRmClient.this.setActionToContext((BindingProvider)WinRmClient.this.winrm, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Receive");
                        return WinRmClient.this.winrm.receive(receive, WinRmClient.RESOURCE_URI, 153600, WinRmClient.this.operationTimeout, WinRmClient.this.locale, WinRmClient.this.shellSelector);
                    }
                });
                this.getStreams(receiveResponse, out, err);
                CommandStateType state = receiveResponse.getCommandState();
                if (COMMAND_STATE_DONE.equals(state.getState())) {
                    return state.getExitCode().intValue();
                }
                LOG.debug("{} is not done. Response it received: {}", (Object)this, (Object)receiveResponse);
                continue;
            }
            catch (SOAPFaultException soapFault) {
                this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED);
                continue;
            }
            break;
        }
    }

    private void assertFaultCode(SOAPFaultException soapFault, String code) {
        try {
            NodeList faultDetails = soapFault.getFault().getDetail().getChildNodes();
            for (int i = 0; i < faultDetails.getLength(); ++i) {
                if (!faultDetails.item(i).getLocalName().equals("WSManFault")) continue;
                if (faultDetails.item(i).getAttributes().getNamedItem("Code").getNodeValue().equals(code)) {
                    LOG.trace("winrm client {} received error 500 response with code {}, response {}", new Object[]{this, code, soapFault});
                    return;
                }
                throw soapFault;
            }
            throw soapFault;
        }
        catch (NullPointerException e) {
            LOG.debug("Error reading Fault Code {}", (Object)soapFault.getFault());
            throw soapFault;
        }
    }

    public int getNumberOfReceiveCalls() {
        return this.numberOfReceiveCalls;
    }

    private void getStreams(ReceiveResponse receiveResponse, Writer out, Writer err) {
        List<StreamType> streams = receiveResponse.getStream();
        for (StreamType s : streams) {
            byte[] value = s.getValue();
            if (value == null) continue;
            if (out != null && "stdout".equals(s.getName())) {
                try {
                    if (value.length > 0) {
                        out.write(new String(value));
                    }
                    if (Boolean.TRUE.equals(s.isEnd())) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (err == null || !"stderr".equals(s.getName())) continue;
            try {
                if (value.length > 0) {
                    err.write(new String(value));
                }
                if (!Boolean.TRUE.equals(s.isEnd())) continue;
                err.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            out.close();
            err.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized WinRm getService() {
        if (this.winrm != null) {
            return this.winrm;
        }
        if (this.context != null) {
            this.cleanupContext = false;
        } else {
            this.context = WinRmClientContext.newInstance();
            this.cleanupContext = true;
        }
        Bus prevBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.context.getBus());
        try {
            WinRm winRm = this.createService();
            return winRm;
        }
        finally {
            if (BusFactory.getThreadDefaultBus((boolean)false) != prevBus) {
                BusFactory.setThreadDefaultBus((Bus)prevBus);
            }
        }
    }

    private synchronized WinRm createService() {
        if (this.winrm != null) {
            return this.winrm;
        }
        RuntimeException lastException = null;
        try {
            this.winrm = null;
            this.doCreateServiceWithBean();
            return this.winrm;
        }
        catch (RuntimeException e) {
            LOG.warn("Error creating WinRm service with mbean strategy (trying other strategies): " + e, (Throwable)e);
            lastException = e;
            try {
                this.winrm = null;
                this.doCreateServiceWithReflectivelySetDelegate();
                this.getAddressingProperties((BindingProvider)this.winrm);
                return this.winrm;
            }
            catch (RuntimeException e2) {
                LOG.warn("Error creating WinRm service with reflective delegate (trying other strategies): " + e2, (Throwable)e2);
                lastException = e2;
                try {
                    this.winrm = null;
                    this.doCreateServiceNormal();
                    return this.winrm;
                }
                catch (RuntimeException e3) {
                    LOG.warn("Error creating WinRm service with many strategies (giving up): " + e3, (Throwable)e3);
                    lastException = e3;
                    throw lastException;
                }
            }
        }
    }

    private synchronized void doCreateServiceNormal() {
        WinRmService service = this.doCreateService_1_CreateMinimalServiceInstance();
        Client client = this.doCreateService_2_GetClient(service);
        this.doCreateService_3_InitializeClientAndService(client);
    }

    private void doCreateServiceWithSystemPropertySet() {
        System.setProperty("javax.xml.ws.spi.Provider", ProviderImpl.class.getName());
        this.doCreateServiceNormal();
    }

    private void doCreateServiceWithReflectivelySetDelegate() {
        WinRmService service = this.doCreateService_1_CreateMinimalServiceInstance();
        try {
            Field delegateField = Service.class.getDeclaredField("delegate");
            delegateField.setAccessible(true);
            ServiceDelegate previousDelegate = (ServiceDelegate)delegateField.get((Object)service);
            if (!previousDelegate.getClass().getName().contains("cxf")) {
                ServiceDelegate serviceDelegate = ((Provider)Class.forName("org.apache.cxf.jaxws.spi.ProviderImpl").newInstance()).createServiceDelegate(WinRmService.WSDL_LOCATION, WinRmService.SERVICE, ((Object)((Object)service)).getClass());
                delegateField.set((Object)service, serviceDelegate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reflectively setting CXF WS service delegate", e);
        }
        Client client = this.doCreateService_2_GetClient(service);
        this.doCreateService_3_InitializeClientAndService(client);
    }

    private synchronized void doCreateServiceWithBean() {
        Client client = this.doCreateServiceWithBean_Part1();
        this.doCreateService_3_InitializeClientAndService(client);
    }

    private synchronized Client doCreateServiceWithBean_Part1() {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.getClientFactoryBean().getServiceFactory().setWsdlURL(WinRmService.WSDL_LOCATION);
        factory.setServiceName(WinRmService.SERVICE);
        factory.setEndpointName(WinRmService.WinRmPort);
        factory.setFeatures(Arrays.asList((Feature)WinRmClient.newMemberSubmissionAddressingFeature()));
        factory.setBus(this.context.getBus());
        this.winrm = (WinRm)factory.create(WinRm.class);
        return ClientProxy.getClient((Object)this.winrm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doCreateServiceInSpecialClassLoader(ClassLoader cl) {
        Client client;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            WinRmService service = this.doCreateService_1_CreateMinimalServiceInstance();
            client = this.doCreateService_2_GetClient(service);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        this.doCreateService_3_InitializeClientAndService(client);
    }

    private synchronized WinRmService doCreateService_1_CreateMinimalServiceInstance() {
        return new WinRmService();
    }

    private synchronized Client doCreateService_2_GetClient(WinRmService service) {
        this.winrm = service.getWinRmPort(WinRmClient.newMemberSubmissionAddressingFeature());
        return ClientProxy.getClient((Object)this.winrm);
    }

    private synchronized void doCreateService_3_InitializeClientAndService(Client client) {
        ServiceInfo si = client.getEndpoint().getEndpointInfo().getService();
        si.setProperty("soap.force.doclit.bare", (Object)true);
        BindingProvider bp = (BindingProvider)this.winrm;
        List<Handler> handlerChain = Arrays.asList(new StripShellResponseHandler());
        bp.getBinding().setHandlerChain(handlerChain);
        Map requestContext = bp.getRequestContext();
        AddressingProperties maps = new AddressingProperties("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        requestContext.put("javax.xml.ws.addressing.context", maps);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endpoint.toExternalForm());
        switch (this.authenticationScheme) {
            case "Basic": {
                bp.getRequestContext().put("javax.xml.ws.security.auth.username", this.username);
                bp.getRequestContext().put("javax.xml.ws.security.auth.password", this.password);
                break;
            }
            case "NTLM": 
            case "Kerberos": {
                TLSClientParameters tlsClientParameters;
                NTCredentials creds = new NTCredentials(this.username, this.password, null, this.domain);
                Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Negotiate", (Object)(this.authenticationScheme.equals("NTLM") ? new SpNegoNTLMSchemeFactory() : new SPNegoSchemeFactory())).register("Kerberos", (Object)new KerberosSchemeFactory()).build();
                bp.getRequestContext().put(Credentials.class.getName(), creds);
                bp.getRequestContext().put("http.autoredirect", true);
                bp.getRequestContext().put(AuthSchemeProvider.class.getName(), authSchemeRegistry);
                AsyncHTTPConduit httpClient = (AsyncHTTPConduit)client.getConduit();
                if (this.disableCertificateChecks) {
                    tlsClientParameters = new TLSClientParameters();
                    tlsClientParameters.setDisableCNCheck(true);
                    tlsClientParameters.setTrustManagers(new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }});
                    httpClient.setTlsClientParameters(tlsClientParameters);
                }
                if (this.hostnameVerifier != null) {
                    tlsClientParameters = new TLSClientParameters();
                    tlsClientParameters.setHostnameVerifier(this.hostnameVerifier);
                    httpClient.setTlsClientParameters(tlsClientParameters);
                }
                HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
                httpClientPolicy.setAllowChunking(false);
                httpClientPolicy.setReceiveTimeout(this.receiveTimeout.longValue());
                httpClient.setClient(httpClientPolicy);
                httpClient.getClient().setAutoRedirect(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("No such authentication scheme " + this.authenticationScheme);
            }
        }
        final Shell shell = new Shell();
        shell.getInputStreams().add("stdin");
        shell.getOutputStreams().add("stdout");
        shell.getOutputStreams().add("stderr");
        if (this.workingDirectory != null) {
            shell.setWorkingDirectory(this.workingDirectory);
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            EnvironmentVariableList env = new EnvironmentVariableList();
            List<EnvironmentVariable> vars = env.getVariable();
            for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                EnvironmentVariable var = new EnvironmentVariable();
                var.setName(entry.getKey());
                var.setValue(entry.getValue());
                vars.add(var);
            }
            shell.setEnvironment(env);
        }
        final OptionSetType optSetCreate = new OptionSetType();
        OptionType optNoProfile = new OptionType();
        optNoProfile.setName("WINRS_NOPROFILE");
        optNoProfile.setValue("FALSE");
        optSetCreate.getOption().add(optNoProfile);
        OptionType optCodepage = new OptionType();
        optCodepage.setName("WINRS_CODEPAGE");
        optCodepage.setValue("437");
        optSetCreate.getOption().add(optCodepage);
        ResourceCreated resourceCreated = this.winrmCallRetryConnFailure(new CallableFunction<ResourceCreated>(){

            @Override
            public ResourceCreated call() {
                WinRmClient.this.setActionToContext((BindingProvider)WinRmClient.this.winrm, "http://schemas.xmlsoap.org/ws/2004/09/transfer/Create");
                return WinRmClient.this.winrm.create(shell, WinRmClient.RESOURCE_URI, 153600, WinRmClient.this.operationTimeout, WinRmClient.this.locale, optSetCreate);
            }
        });
        this.shellId = WinRmClient.getShellId(resourceCreated);
        this.shellSelector = new SelectorSetType();
        SelectorType sel = new SelectorType();
        sel.setName("ShellId");
        sel.getContent().add(this.shellId);
        this.shellSelector.getSelector().add(sel);
    }

    private static String getShellId(ResourceCreated resourceCreated) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (Element el : resourceCreated.getAny()) {
            String shellId;
            try {
                shellId = xpath.evaluate("//*[local-name()='Selector' and @Name='ShellId']", el);
            }
            catch (XPathExpressionException e) {
                throw new IllegalStateException(e);
            }
            if (shellId == null || shellId.isEmpty()) continue;
            return shellId;
        }
        throw new IllegalStateException("Shell ID not fount in " + resourceCreated);
    }

    private static WebServiceFeature newMemberSubmissionAddressingFeature() {
        try {
            WSAddressingFeature webServiceFeature = new WSAddressingFeature();
            webServiceFeature.setAddressingRequired(true);
            return webServiceFeature;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        boolean isBusRunning;
        if (this.context == null) {
            return;
        }
        boolean bl = isBusRunning = this.context.getBus().getState() != Bus.BusState.SHUTDOWN;
        if (!isBusRunning) {
            return;
        }
        try {
            if (this.winrm != null && this.shellSelector != null) {
                try {
                    this.winrmCallRetryConnFailure(new CallableFunction<DeleteResponse>(){

                        @Override
                        public DeleteResponse call() {
                            WinRmClient.this.setActionToContext((BindingProvider)WinRmClient.this.winrm, "http://schemas.xmlsoap.org/ws/2004/09/transfer/Delete");
                            return WinRmClient.this.winrm.delete(null, WinRmClient.RESOURCE_URI, 153600, WinRmClient.this.operationTimeout, WinRmClient.this.locale, WinRmClient.this.shellSelector);
                        }
                    });
                }
                catch (SOAPFaultException soapFault) {
                    this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND);
                }
            }
        }
        finally {
            if (this.cleanupContext) {
                this.context.getBus().shutdown(true);
                this.context = null;
            }
        }
    }

    public static <T> T checkNotNull(T check, String msg) {
        if (check == null) {
            throw new NullPointerException(msg);
        }
        return check;
    }

    private <V> V winrmCallRetryConnFailure(CallableFunction<V> winrmCall) throws SOAPFaultException {
        int retries = this.retriesForConnectionFailures != null ? this.retriesForConnectionFailures : 16;
        ArrayList<WebServiceException> exceptions = new ArrayList<WebServiceException>();
        for (int i = 0; i < retries + 1; ++i) {
            try {
                return winrmCall.call();
            }
            catch (SOAPFaultException soapFault) {
                throw soapFault;
            }
            catch (WebServiceException wsException) {
                if (!(wsException.getCause() instanceof IOException)) {
                    throw new RuntimeException("Exception occurred while making winrm call", wsException);
                }
                LOG.debug("Ignoring exception and retrying (attempt " + (i + 1) + " of " + (retries + 1) + ") {}", (Throwable)wsException);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Exception occured while making winrm call", e.initCause(wsException));
                }
                exceptions.add(wsException);
                continue;
            }
        }
        throw new RuntimeException("failed task " + winrmCall, (Throwable)exceptions.get(0));
    }

    private static interface CallableFunction<V> {
        public V call();
    }

    public static class Builder {
        private static final java.util.Locale DEFAULT_LOCALE = java.util.Locale.US;
        public static final Long DEFAULT_OPERATION_TIMEOUT = 60000L;
        private WinRmClient client;

        public Builder(URL endpoint, String authenticationScheme) {
            this.client = new WinRmClient(endpoint, authenticationScheme);
        }

        public Builder(String endpoint, String authenticationScheme) {
            this(Builder.toUrlUnchecked(WinRmClient.checkNotNull(endpoint, "endpoint")), authenticationScheme);
        }

        public Builder credentials(String username, String password) {
            return this.credentials(null, username, password);
        }

        public Builder credentials(String domain, String username, String password) {
            this.client.domain = domain;
            this.client.username = WinRmClient.checkNotNull(username, "username");
            this.client.password = WinRmClient.checkNotNull(password, "password");
            return this;
        }

        public Builder locale(java.util.Locale locale) {
            Locale l = new Locale();
            l.setLang(WinRmClient.checkNotNull(locale, "locale").toLanguageTag());
            this.client.locale = l;
            return this;
        }

        public Builder operationTimeout(long operationTimeout) {
            this.client.operationTimeout = Builder.toDuration(operationTimeout);
            this.client.receiveTimeout = operationTimeout + 60000L;
            return this;
        }

        public Builder retriesForConnectionFailures(Integer retriesConnectionFailures) {
            if (retriesConnectionFailures < 1) {
                throw new IllegalArgumentException("retriesConnectionFailure should be one or more");
            }
            this.client.retriesForConnectionFailures = retriesConnectionFailures;
            return this;
        }

        public Builder disableCertificateChecks(boolean disableCertificateChecks) {
            this.client.disableCertificateChecks = disableCertificateChecks;
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.client.workingDirectory = WinRmClient.checkNotNull(workingDirectory, "workingDirectory");
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.client.environment = WinRmClient.checkNotNull(environment, "environment");
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.client.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder context(WinRmClientContext context) {
            this.client.context = context;
            return this;
        }

        public WinRmClient build() {
            if (this.client.locale == null) {
                this.locale(DEFAULT_LOCALE);
            }
            if (this.client.operationTimeout == null) {
                this.client.operationTimeout = Builder.toDuration(Builder.DEFAULT_OPERATION_TIMEOUT);
                this.client.receiveTimeout = Builder.DEFAULT_OPERATION_TIMEOUT + 30000L;
            }
            WinRmClient ret = this.client;
            this.client = null;
            return ret;
        }

        private static URL toUrlUnchecked(String endpoint) {
            try {
                return new URL(endpoint);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private static String toDuration(long operationTimeout) {
            BigDecimal bdMs = BigDecimal.valueOf(operationTimeout);
            BigDecimal bdSec = bdMs.divide(BigDecimal.valueOf(1000L));
            DecimalFormat df = new DecimalFormat("PT#.###S", new DecimalFormatSymbols(java.util.Locale.ROOT));
            return df.format(bdSec);
        }
    }
}

