/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaDeserializer;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.headers.MessageTypeSerdeHeaders;
import io.apicurio.registry.serde.jsonschema.JsonSchema;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaDeserializerConfig;
import io.apicurio.registry.serde.jsonschema.JsonSchemaParser;
import io.apicurio.registry.serde.jsonschema.JsonSchemaValidationUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonSchemaKafkaDeserializer<T>
extends AbstractKafkaDeserializer<JsonSchema, T>
implements Deserializer<T> {
    private ObjectMapper mapper;
    private Boolean validationEnabled;
    private JsonSchemaParser<T> parser = new JsonSchemaParser();
    private Class<T> specificReturnClass;
    private MessageTypeSerdeHeaders serdeHeaders;

    public JsonSchemaKafkaDeserializer() {
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client, SchemaResolver<JsonSchema, T> schemaResolver) {
        super(client, schemaResolver);
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client) {
        super(client);
    }

    public JsonSchemaKafkaDeserializer(SchemaResolver<JsonSchema, T> schemaResolver) {
        super(schemaResolver);
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client, Boolean validationEnabled) {
        this(client);
        this.validationEnabled = validationEnabled;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        JsonSchemaKafkaDeserializerConfig config = new JsonSchemaKafkaDeserializerConfig(configs, isKey);
        super.configure((BaseKafkaSerDeConfig)config, isKey);
        if (this.validationEnabled == null) {
            this.validationEnabled = config.validationEnabled();
        }
        this.specificReturnClass = config.getSpecificReturnClass();
        this.serdeHeaders = new MessageTypeSerdeHeaders(new HashMap(configs), isKey);
        if (null == this.mapper) {
            this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled != null && this.validationEnabled != false;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    public SchemaParser<JsonSchema, T> schemaParser() {
        return this.parser;
    }

    protected T readData(ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(null, schema, buffer, start, length);
    }

    protected T readData(Headers headers, ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(headers, schema, buffer, start, length);
    }

    private T internalReadData(Headers headers, ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        byte[] data = new byte[length];
        System.arraycopy(buffer.array(), start, data, 0, length);
        try {
            JsonParser parser = this.mapper.getFactory().createParser(data);
            if (this.isValidationEnabled()) {
                JsonSchemaValidationUtil.validateDataWithSchema(schema, data, this.mapper);
            }
            Class messageType = null;
            if (this.specificReturnClass != null) {
                messageType = this.specificReturnClass;
            } else if (headers == null) {
                JsonNode jsonSchema = this.mapper.readTree(schema.getRawSchema());
                String javaType = null;
                JsonNode javaTypeNode = jsonSchema.get("javaType");
                if (javaTypeNode != null && !javaTypeNode.isNull()) {
                    javaType = javaTypeNode.textValue();
                }
                messageType = javaType == null ? null : Utils.loadClass(javaType);
            } else {
                String javaType = this.serdeHeaders.getMessageType(headers);
                Class clazz = messageType = javaType == null ? null : Utils.loadClass((String)javaType);
            }
            if (messageType == null) {
                return (T)this.mapper.readTree(parser);
            }
            return (T)this.mapper.readValue(parser, messageType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

