/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.registry;

import fr.opensagres.xdocreport.core.registry.AbstractRegistry;
import fr.opensagres.xdocreport.document.DocumentContextHelper;
import fr.opensagres.xdocreport.document.discovery.ITextStylingDocumentHandlerFactoryDiscovery;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.registry.TextStylingTransformerRegistry;
import fr.opensagres.xdocreport.document.textstyling.BasicTransformResult;
import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.ITextStylingTransformer;
import fr.opensagres.xdocreport.document.textstyling.ITransformResult;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateContextHelper;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextStylingRegistry
extends AbstractRegistry<ITextStylingDocumentHandlerFactoryDiscovery> {
    private static final TextStylingRegistry INSTANCE = new TextStylingRegistry();
    private final Map<String, ITextStylingDocumentHandlerFactoryDiscovery> documentHandlers = new HashMap<String, ITextStylingDocumentHandlerFactoryDiscovery>();

    public TextStylingRegistry() {
        super(ITextStylingDocumentHandlerFactoryDiscovery.class);
    }

    public static TextStylingRegistry getRegistry() {
        return INSTANCE;
    }

    protected boolean registerInstance(ITextStylingDocumentHandlerFactoryDiscovery discovery) {
        this.documentHandlers.put(discovery.getId(), discovery);
        return true;
    }

    protected void doDispose() {
        this.documentHandlers.clear();
    }

    public ITransformResult transform(String initialContent, String syntaxKind, boolean syntaxWithDirective, String documentKind, String elementId, IContext context, String entryName) {
        ITextStylingTransformer transformer = TextStylingTransformerRegistry.getRegistry().getTextStylingTransformer(syntaxKind);
        if (transformer != null) {
            try {
                ITemplateEngine templateEngine;
                String content = initialContent;
                if (syntaxWithDirective && (templateEngine = TemplateContextHelper.getTemplateEngine((IContext)context)) != null) {
                    StringWriter newContent = new StringWriter();
                    templateEngine.process(entryName, context, (Reader)new StringReader(initialContent), (Writer)newContent);
                    content = newContent.toString();
                }
                IDocumentHandler visitor = this.createDocumentHandler(documentKind, elementId, context, entryName);
                return transformer.transform(content, visitor);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new BasicTransformResult(initialContent);
            }
        }
        return new BasicTransformResult(initialContent);
    }

    public IDocumentHandler createDocumentHandler(String documentKind, String elementId, IContext context, String entryName) {
        super.initializeIfNeeded();
        ITextStylingDocumentHandlerFactoryDiscovery factory = this.documentHandlers.get(documentKind);
        if (factory == null) {
            return null;
        }
        BufferedElement parent = DocumentContextHelper.getElementById(context, elementId);
        return factory.createDocumentHandler(parent, context, entryName);
    }
}

