/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.core.document.ImageFormat;
import fr.opensagres.xdocreport.document.images.AbstractInputStreamImageProvider;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathImageProvider
extends AbstractInputStreamImageProvider {
    private final ClassLoader classLoader;
    private final Class<?> clazz;
    private final String resourceName;
    private final ImageFormat imageFormat;

    public ClassPathImageProvider(ClassLoader classLoader, String resourceName) {
        this(classLoader, resourceName, false);
    }

    public ClassPathImageProvider(ClassLoader classLoader, String resourceName, boolean useImageSize) {
        super(useImageSize);
        this.classLoader = classLoader;
        this.resourceName = resourceName;
        this.clazz = null;
        this.imageFormat = ImageFormat.getFormatByResourceName((String)resourceName);
    }

    public ClassPathImageProvider(Class<?> clazz, String resourceName) {
        this(clazz, resourceName, false);
    }

    public ClassPathImageProvider(Class<?> clazz, String resourceName, boolean useImageSize) {
        super(useImageSize);
        this.clazz = clazz;
        this.resourceName = resourceName;
        this.classLoader = null;
        this.imageFormat = ImageFormat.getFormatByResourceName((String)resourceName);
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.clazz != null) {
            return this.clazz.getResourceAsStream(this.resourceName);
        }
        return this.classLoader.getResourceAsStream(this.resourceName);
    }

    @Override
    public ImageFormat getImageFormat() {
        return this.imageFormat;
    }
}

