/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.poi.xwpf.converter.core.Color;
import fr.opensagres.poi.xwpf.converter.core.ListItemContext;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.core.ParagraphLineSpacing;
import fr.opensagres.poi.xwpf.converter.core.TableWidth;
import fr.opensagres.poi.xwpf.converter.core.openxmlformats.IOpenXMLFormatsPartProvider;
import fr.opensagres.poi.xwpf.converter.core.openxmlformats.OpenXMlFormatsVisitor;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.StringUtils;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.poi.xwpf.converter.pdf.internal.Converter;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableAnchor;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableHeaderFooter;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableMasterPage;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableParagraph;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTable;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTableCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedChunk;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import fr.opensagres.xdocreport.itext.extension.ExtendedImage;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.itext.extension.font.FontGroup;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.xmlbeans.XmlTokenSource;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STWrapText;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class FastPdfMapper
extends OpenXMlFormatsVisitor<IITextContainer, PdfOptions, StylableMasterPage> {
    private static final String TAB = "\t";
    private static final Logger LOGGER = Logger.getLogger(FastPdfMapper.class.getName());
    private final OutputStream out;
    private StylableDocument pdfDocument;
    private Font currentRunFontAscii;
    private Font currentRunFontEastAsia;
    private Font currentRunFontHAnsi;
    private UnderlinePatterns currentRunUnderlinePatterns;
    private Color currentRunBackgroundColor;
    private Float currentRunX;
    private Float currentPageWidth;
    private VerticalAlign currentRunVerticalAlign = VerticalAlign.BASELINE;

    public FastPdfMapper(IOpenXMLFormatsPartProvider provider, OutputStream out, PdfOptions options) throws Exception {
        super(provider, (Options)(options != null ? options : PdfOptions.getDefault()));
        this.out = out;
    }

    protected IITextContainer startVisitDocument() throws Exception {
        this.pdfDocument = new StylableDocument(this.out, ((PdfOptions)this.options).getConfiguration());
        this.pdfDocument.setMasterPageManager(this.getMasterPageManager());
        return this.pdfDocument;
    }

    protected void endVisitDocument() throws Exception {
        this.pdfDocument.close();
        this.out.close();
    }

    public void setActiveMasterPage(StylableMasterPage masterPage) {
        this.pdfDocument.setActiveMasterPage(masterPage);
    }

    public StylableMasterPage createMasterPage(CTSectPr sectPr) {
        return new StylableMasterPage(sectPr);
    }

    protected void pageBreak() throws Exception {
        this.pdfDocument.pageBreak();
    }

    protected IITextContainer startVisitParagraph(CTP paragraph, ListItemContext itemContext, IITextContainer pdfParentContainer) throws Exception {
        ParagraphAlignment alignment;
        ParagraphLineSpacing lineSpacing;
        Float spacingAfter;
        Float spacingBefore;
        Float indentationHanging;
        Float indentationFirstLine;
        Float indentationRight;
        StylableParagraph pdfParagraph = this.pdfDocument.createParagraph(pdfParentContainer);
        CTTbl parentTable = super.getParentTable();
        Float indentationLeft = this.stylesDocument.getIndentationLeft(paragraph, parentTable);
        if (indentationLeft != null) {
            pdfParagraph.setIndentationLeft(indentationLeft.floatValue());
        }
        if ((indentationRight = this.stylesDocument.getIndentationRight(paragraph, parentTable)) != null) {
            pdfParagraph.setIndentationRight(indentationRight.floatValue());
        }
        if ((indentationFirstLine = this.stylesDocument.getIndentationFirstLine(paragraph, parentTable)) != null) {
            pdfParagraph.setFirstLineIndent(indentationFirstLine.floatValue());
        }
        if ((indentationHanging = this.stylesDocument.getIndentationHanging(paragraph, parentTable)) != null) {
            pdfParagraph.setFirstLineIndent(-indentationHanging.floatValue());
        }
        if ((spacingBefore = this.stylesDocument.getSpacingBefore(paragraph, parentTable)) != null) {
            pdfParagraph.setSpacingBefore(spacingBefore.floatValue());
        }
        if ((spacingAfter = this.stylesDocument.getSpacingAfter(paragraph, parentTable)) != null) {
            pdfParagraph.setSpacingAfter(spacingAfter.floatValue());
        }
        if ((lineSpacing = this.stylesDocument.getParagraphSpacing(paragraph, parentTable)) != null) {
            if (lineSpacing.getLeading() != null && lineSpacing.getMultipleLeading() != null) {
                pdfParagraph.setLeading(lineSpacing.getLeading().floatValue(), lineSpacing.getMultipleLeading().floatValue());
            } else {
                if (lineSpacing.getLeading() != null) {
                    pdfParagraph.setLeading(lineSpacing.getLeading().floatValue());
                }
                if (lineSpacing.getMultipleLeading() != null) {
                    pdfParagraph.setMultipliedLeading(lineSpacing.getMultipleLeading().floatValue());
                }
            }
        }
        if ((alignment = this.stylesDocument.getParagraphAlignment(paragraph, parentTable)) != null) {
            switch (alignment) {
                case LEFT: {
                    pdfParagraph.setAlignment(0);
                    break;
                }
                case RIGHT: {
                    pdfParagraph.setAlignment(2);
                    break;
                }
                case CENTER: {
                    pdfParagraph.setAlignment(1);
                    break;
                }
                case BOTH: {
                    pdfParagraph.setAlignment(3);
                    break;
                }
            }
        }
        return pdfParagraph;
    }

    protected void endVisitParagraph(CTP paragraph, IITextContainer pdfParentContainer, IITextContainer pdfParagraphContainer) throws Exception {
        ExtendedParagraph pdfParagraph = (ExtendedParagraph)pdfParagraphContainer;
        pdfParentContainer.addElement(pdfParagraph.getElement());
    }

    protected void visitRun(CTR run, CTP paragraph, boolean pageNumber, String url, IITextContainer pdfParagraphContainer) throws Exception {
        Boolean strike;
        Boolean italic;
        String fontFamilyAscii = this.stylesDocument.getFontFamilyAscii(run, paragraph);
        String fontFamilyEastAsia = this.stylesDocument.getFontFamilyEastAsia(run, paragraph);
        String fontFamilyHAnsi = this.stylesDocument.getFontFamilyHAnsi(run, paragraph);
        Float fontSize = this.stylesDocument.getFontSize(run, paragraph);
        if (fontSize == null) {
            fontSize = Float.valueOf(-1.0f);
        }
        int fontStyle = 0;
        Boolean bold = this.stylesDocument.getFontStyleBold(run, paragraph);
        if (bold != null && bold.booleanValue()) {
            fontStyle |= 1;
        }
        if ((italic = this.stylesDocument.getFontStyleItalic(run, paragraph)) != null && italic.booleanValue()) {
            fontStyle |= 2;
        }
        if ((strike = this.stylesDocument.getFontStyleStrike(run, paragraph)) != null && strike.booleanValue()) {
            fontStyle |= 8;
        }
        Color fontColor = this.stylesDocument.getFontColor(run, paragraph);
        this.currentRunVerticalAlign = this.stylesDocument.getVerticalAlign(run);
        switch (this.currentRunVerticalAlign) {
            case SUBSCRIPT: 
            case SUPERSCRIPT: {
                fontSize = Float.valueOf(fontSize.floatValue() * this.stylesDocument.getVerticalAlignFontFactor());
            }
        }
        this.currentRunFontAscii = this.getFont(fontFamilyAscii, fontSize, fontStyle, fontColor);
        this.currentRunFontEastAsia = this.getFont(fontFamilyEastAsia, fontSize, fontStyle, fontColor);
        this.currentRunFontHAnsi = this.getFont(fontFamilyHAnsi, fontSize, fontStyle, fontColor);
        this.currentRunUnderlinePatterns = this.stylesDocument.getUnderline(run, paragraph);
        this.currentRunBackgroundColor = this.stylesDocument.getBackgroundColor(run, paragraph);
        if (this.currentRunBackgroundColor == null) {
            this.currentRunBackgroundColor = this.stylesDocument.getTextHighlighting(run, paragraph);
        }
        StylableParagraph pdfParagraph = (StylableParagraph)pdfParagraphContainer;
        pdfParagraph.adjustMultipliedLeading(this.currentRunFontAscii);
        String listItemText = pdfParagraph.getListItemText();
        if (StringUtils.isNotEmpty((String)listItemText)) {
            listItemText = listItemText + "    ";
            String listItemFontFamily = pdfParagraph.getListItemFontFamily();
            Float listItemFontSize = pdfParagraph.getListItemFontSize();
            int listItemFontStyle = pdfParagraph.getListItemFontStyle();
            java.awt.Color listItemFontColor = pdfParagraph.getListItemFontColor();
            Font listItemFont = ((PdfOptions)this.options).getFontProvider().getFont(listItemFontFamily != null ? listItemFontFamily : fontFamilyAscii, ((PdfOptions)this.options).getFontEncoding(), (listItemFontSize != null ? listItemFontSize : fontSize).floatValue(), listItemFontStyle != 0 ? listItemFontStyle : fontStyle, listItemFontColor != null ? listItemFontColor : Converter.toAwtColor(fontColor));
            Chunk symbol = this.createTextChunk(listItemText, false, listItemFont, this.currentRunUnderlinePatterns, this.currentRunBackgroundColor);
            pdfParagraph.add(symbol);
            pdfParagraph.setListItemText(null);
        }
        IITextContainer container = pdfParagraphContainer;
        if (url != null) {
            StylableAnchor pdfAnchor = new StylableAnchor();
            pdfAnchor.setReference(url);
            pdfAnchor.setITextContainer(container);
            container = pdfAnchor;
        }
        super.visitRun(run, paragraph, pageNumber, url, (Object)pdfParagraphContainer);
        if (url != null) {
            pdfParagraphContainer.addElement((Element)((StylableAnchor)container));
        }
        this.currentRunFontAscii = null;
        this.currentRunFontEastAsia = null;
        this.currentRunFontHAnsi = null;
        this.currentRunUnderlinePatterns = null;
        this.currentRunBackgroundColor = null;
        this.currentRunVerticalAlign = VerticalAlign.BASELINE;
    }

    private Font getFont(String fontFamily, Float fontSize, int fontStyle, Color fontColor) {
        String fontToUse = this.stylesDocument.getFontNameToUse(fontFamily);
        if (StringUtils.isNotEmpty((String)fontToUse)) {
            return ((PdfOptions)this.options).getFontProvider().getFont(fontToUse, ((PdfOptions)this.options).getFontEncoding(), fontSize.floatValue(), fontStyle, Converter.toAwtColor(fontColor));
        }
        Font font = ((PdfOptions)this.options).getFontProvider().getFont(fontFamily, ((PdfOptions)this.options).getFontEncoding(), fontSize.floatValue(), fontStyle, Converter.toAwtColor(fontColor));
        if (!this.isFontExists(font)) {
            try {
                List altNames = this.stylesDocument.getFontsAltName(fontFamily);
                if (altNames != null) {
                    for (String altName : altNames) {
                        if (fontFamily.equals(altName) || !this.isFontExists(font = this.getFont(altName, fontSize, fontStyle, fontColor))) continue;
                        this.stylesDocument.setFontNameToUse(fontFamily, altName);
                        return font;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
        return font;
    }

    private boolean isFontExists(Font font) {
        return font != null && font.getBaseFont() != null;
    }

    protected void visitText(CTText docxText, boolean pageNumber, IITextContainer pdfParagraphContainer) throws Exception {
        Font font = this.currentRunFontAscii;
        Font fontAsian = this.currentRunFontEastAsia;
        Font fontComplex = this.currentRunFontHAnsi;
        this.createAndAddChunks(pdfParagraphContainer, docxText.getStringValue(), this.currentRunUnderlinePatterns, this.currentRunBackgroundColor, pageNumber, font, fontAsian, fontComplex);
    }

    private Chunk createTextChunk(String text, boolean pageNumber, Font currentRunFont, UnderlinePatterns currentRunUnderlinePatterns, Color currentRunBackgroundColor) {
        ExtendedChunk textChunk;
        Object object = textChunk = pageNumber ? new ExtendedChunk((ExtendedDocument)this.pdfDocument, true, currentRunFont) : new Chunk(text, currentRunFont);
        if (currentRunUnderlinePatterns != null) {
            boolean singleUnderlined = false;
            switch (currentRunUnderlinePatterns) {
                case SINGLE: {
                    singleUnderlined = true;
                    break;
                }
            }
            if (singleUnderlined) {
                textChunk.setUnderline(0.1f, -2.0f);
            }
        }
        if (currentRunBackgroundColor != null) {
            textChunk.setBackground(Converter.toAwtColor(currentRunBackgroundColor));
        }
        if (this.currentRunX != null) {
            FastPdfMapper fastPdfMapper = this;
            fastPdfMapper.currentRunX = Float.valueOf(fastPdfMapper.currentRunX.floatValue() + textChunk.getWidthPoint());
        }
        switch (this.currentRunVerticalAlign) {
            case SUBSCRIPT: {
                textChunk.setTextRise(-currentRunFont.getSize() * this.stylesDocument.getVerticalAlignOffset());
                break;
            }
            case SUPERSCRIPT: {
                textChunk.setTextRise(currentRunFont.getSize() * this.stylesDocument.getVerticalAlignOffset());
            }
        }
        return textChunk;
    }

    private void createAndAddChunks(IITextContainer parent, String textContent, UnderlinePatterns underlinePatterns, Color backgroundColor, boolean pageNumber, Font font, Font fontAsian, Font fontComplex) {
        StringBuilder sbuf = new StringBuilder();
        FontGroup currentGroup = FontGroup.WESTERN;
        for (int i = 0; i < textContent.length(); ++i) {
            char ch = textContent.charAt(i);
            FontGroup group = FontGroup.getUnicodeGroup((char)ch, (Font)font, (Font)fontAsian, (Font)fontComplex);
            if (sbuf.length() == 0 || currentGroup.equals((Object)group)) {
                sbuf.append(ch);
            } else {
                Font chunkFont = this.getFont(font, fontAsian, fontComplex, currentGroup);
                Chunk chunk = this.createTextChunk(sbuf.toString(), pageNumber, chunkFont, underlinePatterns, backgroundColor);
                parent.addElement((Element)chunk);
                sbuf.setLength(0);
                sbuf.append(ch);
            }
            currentGroup = group;
        }
        Font chunkFont = this.getFont(font, fontAsian, fontComplex, currentGroup);
        Chunk chunk = this.createTextChunk(sbuf.toString(), pageNumber, chunkFont, underlinePatterns, backgroundColor);
        parent.addElement((Element)chunk);
    }

    private Font getFont(Font font, Font fontAsian, Font fontComplex, FontGroup group) {
        switch (group) {
            case WESTERN: {
                return font;
            }
            case ASIAN: {
                return fontAsian;
            }
            case COMPLEX: {
                return fontComplex;
            }
        }
        return font;
    }

    protected void visitTab(CTPTab o, IITextContainer paragraphContainer) throws Exception {
    }

    protected void visitTabs(CTTabs tabs, IITextContainer paragraphContainer) throws Exception {
    }

    protected void visitBookmark(CTBookmark bookmark, CTP paragraph, IITextContainer paragraphContainer) throws Exception {
    }

    protected void addNewLine(CTBr br, IITextContainer paragraphContainer) throws Exception {
        paragraphContainer.addElement((Element)Chunk.NEWLINE);
    }

    protected void visitHeader(CTHdrFtr currentHeader, CTHdrFtrRef headerRef, CTSectPr sectPr, StylableMasterPage masterPage) throws Exception {
        STTwipsMeasure headerY = sectPr.getPgMar() != null ? sectPr.getPgMar().xgetHeader() : null;
        this.currentPageWidth = sectPr.getPgMar() != null ? Float.valueOf(DxaUtil.dxa2points((STTwipsMeasure)sectPr.getPgSz().xgetW())) : null;
        StylableHeaderFooter pdfHeader = new StylableHeaderFooter(this.pdfDocument, headerY, false);
        StylableTableCell tableCell = pdfHeader.getTableCell();
        this.visitBodyElements((XmlTokenSource)currentHeader, (Object)tableCell);
        masterPage.setHeader(pdfHeader);
        this.currentPageWidth = null;
    }

    protected void visitFooter(CTHdrFtr currentFooter, CTHdrFtrRef footerRef, CTSectPr sectPr, StylableMasterPage masterPage) throws Exception {
        STTwipsMeasure footerY = sectPr.getPgMar() != null ? sectPr.getPgMar().xgetFooter() : null;
        this.currentPageWidth = sectPr.getPgMar() != null ? Float.valueOf(DxaUtil.dxa2points((STTwipsMeasure)sectPr.getPgSz().xgetW())) : null;
        StylableHeaderFooter pdfFooter = new StylableHeaderFooter(this.pdfDocument, footerY, false);
        StylableTableCell tableCell = pdfFooter.getTableCell();
        this.visitBodyElements((XmlTokenSource)currentFooter, (Object)tableCell);
        masterPage.setFooter(pdfFooter);
        this.currentPageWidth = null;
    }

    protected IITextContainer startVisitTable(CTTbl table, float[] colWidths, IITextContainer pdfParentContainer) throws Exception {
        StylableTable pdfPTable = this.createPDFTable(table, colWidths, pdfParentContainer);
        return pdfPTable;
    }

    private StylableTable createPDFTable(CTTbl table, float[] colWidths, IITextContainer pdfParentContainer) throws DocumentException {
        Float indentation;
        TableWidth tableWidth = this.stylesDocument.getTableWidth(table);
        StylableTable pdfPTable = this.pdfDocument.createTable(pdfParentContainer, colWidths.length);
        pdfPTable.setTotalWidth(colWidths);
        if (tableWidth != null && tableWidth.width > 0.0f) {
            if (tableWidth.percentUnit) {
                pdfPTable.setWidthPercentage(tableWidth.width);
            } else {
                pdfPTable.setTotalWidth(tableWidth.width);
            }
        }
        pdfPTable.setLockedWidth(true);
        ParagraphAlignment alignment = this.stylesDocument.getTableAlignment(table);
        if (alignment != null) {
            switch (alignment) {
                case LEFT: {
                    pdfPTable.setHorizontalAlignment(0);
                    break;
                }
                case RIGHT: {
                    pdfPTable.setHorizontalAlignment(2);
                    break;
                }
                case CENTER: {
                    pdfPTable.setHorizontalAlignment(1);
                    break;
                }
                case BOTH: {
                    pdfPTable.setHorizontalAlignment(3);
                    break;
                }
            }
        }
        if ((indentation = this.stylesDocument.getTableIndentation(table)) != null) {
            pdfPTable.setPaddingLeft(indentation.floatValue());
        }
        return pdfPTable;
    }

    protected void endVisitTable(CTTbl table, IITextContainer parentContainer, IITextContainer tableContainer) throws Exception {
        parentContainer.addElement(((ExtendedPdfPTable)tableContainer).getElement());
    }

    protected void startVisitTableRow(CTRow row, IITextContainer tableContainer, boolean headerRow) throws Exception {
        if (headerRow) {
            PdfPTable table = (PdfPTable)tableContainer;
            table.setHeaderRows(table.getHeaderRows() + 1);
        }
    }

    protected IITextContainer startVisitTableCell(CTTc cell, IITextContainer tableContainer) throws Exception {
        StylableTable pdfPTable = (StylableTable)tableContainer;
        StylableTableCell pdfPCell = this.pdfDocument.createTableCell(pdfPTable);
        Color backgroundColor = this.stylesDocument.getTableCellBackgroundColor(cell);
        if (backgroundColor != null) {
            pdfPCell.setBackgroundColor(Converter.toAwtColor(backgroundColor));
        }
        return pdfPCell;
    }

    protected void endVisitTableCell(CTTc cell, IITextContainer tableContainer, IITextContainer tableCellContainer) throws Exception {
        ExtendedPdfPTable pdfPTable = (ExtendedPdfPTable)tableContainer;
        ExtendedPdfPCell pdfPCell = (ExtendedPdfPCell)tableCellContainer;
        pdfPTable.addCell((PdfPCell)pdfPCell);
    }

    protected void visitPicture(CTPicture picture, Float offsetX, STRelFromH.Enum relativeFromH, Float offsetY, STRelFromV.Enum relativeFromV, STWrapText.Enum wrapText, IITextContainer pdfParentContainer) throws Exception {
        CTPositiveSize2D ext = picture.getSpPr().getXfrm().getExt();
        long x = ext.getCx();
        long y = ext.getCy();
        byte[] pictureData = super.getPictureBytes(picture);
        if (pictureData != null) {
            try {
                Image img = Image.getInstance((byte[])pictureData);
                img.scaleAbsolute(DxaUtil.emu2points((long)x), DxaUtil.emu2points((long)y));
                IITextContainer parentOfParentContainer = pdfParentContainer.getITextContainer();
                if (parentOfParentContainer != null && parentOfParentContainer instanceof PdfPCell) {
                    parentOfParentContainer.addElement((Element)img);
                } else {
                    float chunkOffsetX = 0.0f;
                    if (offsetX != null) {
                        if (STRelFromH.CHARACTER.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.COLUMN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.INSIDE_MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.LEFT_MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = this.pdfDocument.left() + offsetX.floatValue();
                        } else if (STRelFromH.OUTSIDE_MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.PAGE.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue() - this.pdfDocument.left();
                        }
                    }
                    float chunkOffsetY = 0.0f;
                    boolean useExtendedImage = false;
                    if (STRelFromV.PARAGRAPH.equals(relativeFromV)) {
                        useExtendedImage = true;
                    }
                    if (useExtendedImage) {
                        ExtendedImage extImg = new ExtendedImage(img, -offsetY.floatValue());
                        if (STRelFromV.PARAGRAPH.equals(relativeFromV)) {
                            chunkOffsetY = -extImg.getScaledHeight();
                        }
                        Chunk chunk = new Chunk((Image)extImg, chunkOffsetX, chunkOffsetY, false);
                        pdfParentContainer.addElement((Element)chunk);
                    } else {
                        if (pdfParentContainer instanceof Paragraph) {
                            Paragraph paragraph = (Paragraph)pdfParentContainer;
                            paragraph.setSpacingBefore(paragraph.getSpacingBefore() + 5.0f);
                        }
                        pdfParentContainer.addElement((Element)new Chunk(img, chunkOffsetX, chunkOffsetY, false));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }
}

