/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;
import fr.opensagres.xdocreport.itext.extension.MasterPage;
import java.util.LinkedList;

public class ExtendedHeaderFooter
extends PdfPageEventHelper {
    private final LinkedList<MasterPage> masterPagesStack = new LinkedList();
    private final ExtendedDocument document;

    public ExtendedHeaderFooter(ExtendedDocument document) {
        this.document = document;
    }

    public void onStartPage(PdfWriter writer, Document doc) {
        MasterPage masterPage = null;
        if (!this.masterPagesStack.isEmpty()) {
            masterPage = this.masterPagesStack.removeLast();
        }
        if (masterPage == null) {
            masterPage = this.document.getDefaultMasterPage();
        }
        if (masterPage != null) {
            float y;
            IMasterPageHeaderFooter header = masterPage.getHeader();
            IMasterPageHeaderFooter footer = masterPage.getFooter();
            if (header != null) {
                y = this.document.getPageSize().getHeight();
                header.writeSelectedRows(0, -1, 0.0f, y, writer.getDirectContentUnder());
            }
            if (footer != null) {
                y = footer.getTotalHeight();
                footer.writeSelectedRows(0, -1, 0.0f, y, writer.getDirectContentUnder());
            }
        }
    }

    public void setMasterPage(MasterPage masterPage) {
        IMasterPageHeaderFooter header = masterPage.getHeader();
        IMasterPageHeaderFooter footer = masterPage.getFooter();
        float marginLeft = this.document.getOriginMarginLeft();
        float marginRight = this.document.getOriginMarginRight();
        float marginTop = this.document.getOriginMarginTop();
        if (header != null) {
            marginTop += header.getTotalHeight();
        }
        float marginBottom = this.document.getOriginMarginBottom();
        if (footer != null) {
            marginBottom += footer.getTotalHeight();
        }
        this.document.setMargins(marginLeft, marginRight, marginTop, marginBottom);
        this.masterPagesStack.addFirst(masterPage);
    }
}

