/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.maven.inject;

import de.m3y.maven.inject.Injection;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="inject", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(goal="inject", lifecycle="process-classes")
public class MavenInjectMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Injection[] injections;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File outputDirectory;

    public void execute() throws MojoFailureException {
        URLClassLoader classLoader = this.createClassLoader();
        for (Injection injection : this.injections) {
            this.doInject(classLoader, injection);
        }
    }

    private void doInject(ClassLoader classLoader, Injection injection) throws MojoFailureException {
        String value = injection.getValue();
        if (null == value) {
            throw new MojoFailureException("Value is null for injection " + injection);
        }
        if (null != injection.getPointCut()) {
            this.handleInject(classLoader, injection.getPointCut(), value);
        }
        if (null != injection.getPointCuts()) {
            for (String pointcut : injection.getPointCuts()) {
                this.handleInject(classLoader, pointcut, value);
            }
        }
    }

    private void handleInject(ClassLoader classLoader, String pointcut, String value) throws MojoFailureException {
        this.getLog().info((CharSequence)("Injecting value '" + value + "' into " + pointcut));
        SourceTarget sourceTarget = this.parseSourceTarget(pointcut);
        try {
            Class<?> clazz = classLoader.loadClass(sourceTarget.clazzName);
            DynamicType.Builder builder = new ByteBuddy().redefine(clazz);
            if (MavenInjectMojo.hasField(clazz, sourceTarget)) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Found field " + clazz.getDeclaredField(sourceTarget.attribute)));
                }
                builder = builder.field((ElementMatcher)ElementMatchers.named((String)sourceTarget.attribute)).value(value);
                Field field = clazz.getDeclaredField(sourceTarget.attribute);
                int modifiers = field.getModifiers();
                if (!Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers)) {
                    this.getLog().warn((CharSequence)("Non-final variable " + sourceTarget.clazzName + "." + sourceTarget.attribute + " initialization conflicts with default-constructor-based initialisation. Make variable final for expected behaviour."));
                }
            } else {
                List<Method> declaredMethods = MavenInjectMojo.findMethodCandidates(clazz, sourceTarget.attribute);
                if (declaredMethods.size() == 1) {
                    Method method = declaredMethods.get(0);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Found method " + method));
                    }
                    builder = builder.method((ElementMatcher)ElementMatchers.named((String)sourceTarget.attribute)).intercept((Implementation)FixedValue.value((Object)value));
                } else {
                    throw new MojoFailureException("Found more than one target for method: " + declaredMethods);
                }
            }
            try (DynamicType.Unloaded dynamicType = builder.make();){
                dynamicType.saveIn(this.outputDirectory);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Can not load " + sourceTarget.clazzName, (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoFailureException("Can not inject value " + value + " into " + sourceTarget.clazzName + "." + sourceTarget.attribute, (Throwable)e);
        }
    }

    private static List<Method> findMethodCandidates(Class<?> clazz, String methodName) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(methodName)).collect(Collectors.toList());
    }

    private static boolean hasField(Class<?> clazz, SourceTarget sourceTarget) {
        try {
            clazz.getDeclaredField(sourceTarget.attribute);
            return true;
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }

    private SourceTarget parseSourceTarget(String target) throws MojoFailureException {
        int idx = target.lastIndexOf(46);
        if (idx < 0) {
            throw new MojoFailureException("Can not parse " + target + " into pattern <FULL_CLASS_NAME>.<ATTRIBUTE|METHOD>. Expected pattern like foo.Bar.MY_VERSION or foo.Bar.getSomeValue");
        }
        SourceTarget sourceTarget = new SourceTarget();
        sourceTarget.clazzName = target.substring(0, idx);
        sourceTarget.attribute = target.substring(idx + 1);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Extract class " + sourceTarget.clazzName + " and attribute/method " + sourceTarget.attribute));
        }
        return sourceTarget;
    }

    private URLClassLoader createClassLoader() throws MojoFailureException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object element : classpathElements) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding " + element + " to classpath"));
                }
                urls.add(FileSystems.getDefault().getPath(element.toString(), new String[0]).toUri().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[0]), ByteBuddy.class.getClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("Can not load project compile classpath", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SourceTarget {
        String clazzName;
        String attribute;

        private SourceTarget() {
        }
    }
}

