/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;

public class RescaledIntegrand
implements UnaryOperator<double[]> {
    private UnaryOperator<double[]> integrand;
    private AtomicBoolean gracefulStop;
    private double lowerBound;
    private double upperBound;
    private double scaledLowerBound;
    private double scaledUpperBound;

    public RescaledIntegrand(UnaryOperator<double[]> integrand, double lowerBound, double upperBound, AtomicBoolean gracefulStop) {
        this.integrand = integrand;
        this.gracefulStop = gracefulStop;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (Double.isFinite(lowerBound) && Double.isFinite(upperBound)) {
            this.scaledLowerBound = lowerBound;
            this.scaledUpperBound = upperBound;
        } else if (Double.isFinite(lowerBound) && Double.isInfinite(upperBound) || Double.isInfinite(lowerBound) && Double.isFinite(upperBound)) {
            this.scaledLowerBound = 0.0;
            this.scaledUpperBound = 1.0;
        } else if (Double.isInfinite(lowerBound) && Double.isInfinite(upperBound)) {
            this.scaledLowerBound = -1.0;
            this.scaledUpperBound = 1.0;
        }
    }

    public double getScaledLowerBound() {
        return this.scaledLowerBound;
    }

    public double getScaledUpperBound() {
        return this.scaledUpperBound;
    }

    @Override
    public double[] apply(double[] x) {
        int i;
        if (Double.isFinite(this.lowerBound) && Double.isFinite(this.upperBound)) {
            return (double[])this.integrand.apply(x);
        }
        int nPoints = x.length;
        double[] rescaledX = new double[nPoints];
        double[] jacobianFactors = new double[nPoints];
        if (Double.isFinite(this.lowerBound) && Double.isInfinite(this.upperBound)) {
            for (i = 0; i < nPoints; ++i) {
                rescaledX[i] = this.lowerBound + x[i] / (1.0 - x[i]);
                jacobianFactors[i] = 1.0 / ((1.0 - x[i]) * (1.0 - x[i]));
            }
        } else if (Double.isInfinite(this.lowerBound) && Double.isFinite(this.upperBound)) {
            for (i = 0; i < nPoints; ++i) {
                rescaledX[i] = this.upperBound - x[i] / (1.0 - x[i]);
                jacobianFactors[i] = 1.0 / ((1.0 - x[i]) * (1.0 - x[i]));
            }
        } else {
            for (i = 0; i < nPoints; ++i) {
                rescaledX[i] = x[i] / (1.0 - x[i] * x[i]);
                jacobianFactors[i] = (1.0 + x[i] * x[i]) / ((1.0 - x[i] * x[i]) * (1.0 - x[i] * x[i]));
            }
        }
        double[] evalIntegrand = (double[])this.integrand.apply(rescaledX);
        if (!this.gracefulStop.get()) {
            for (int i2 = 0; i2 < nPoints; ++i2) {
                int n = i2;
                evalIntegrand[n] = evalIntegrand[n] * jacobianFactors[i2];
            }
            return evalIntegrand;
        }
        return null;
    }
}

